# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' sort vector y by values in vector x
#' 
#' @param y numeric vector
#' @param x numeric vector
#' @keywords internal
#' @return numeric vector
Cpporder <- function(y, x) {
    .Call(`_R2sample_Cpporder`, y, x)
}

#' find test statistics for continuous data
#' 
#' @param x first continuous data set
#' @param y second continuous data set
#' @keywords internal
#' @return A vector of test statistics
TS_cont <- function(x, y) {
    .Call(`_R2sample_TS_cont`, x, y)
}

#' find test statistics for discrete data
#' 
#' @param x integer vector of data set 1
#' @param y integer vector of data set 2
#' @param vals numeric vector of values of discrete data set
#' @param ADweights A vector of weights for AD method
#' @keywords internal
#' @return A vector of test statistics
TS_disc <- function(x, y, vals, ADweights = as.numeric( c(2))) {
    .Call(`_R2sample_TS_disc`, x, y, vals, ADweights)
}

#' find test statistics for continuous data with weights
#' 
#' @param x first continuous data set
#' @param y second continuous data set
#' @param wx weights of x
#' @param wy weights of y
#' @keywords internal
#' @return A vector of test statistics
TSw_cont <- function(x, y, wx, wy) {
    .Call(`_R2sample_TSw_cont`, x, y, wx, wy)
}

#' find test statistics for discrete data
#' 
#' @param x  vector of weights data set 1
#' @param y  vector of weights data set 2
#' @keywords internal
#' @return A vector of test statistics
TSw_disc <- function(x, y) {
    .Call(`_R2sample_TSw_disc`, x, y)
}

#' find counts in bins. Useful for power calculations. Replaces hist command from R.
#' 
#' @param x numeric vector
#' @param bins numeric vector
#' @keywords internal
#' @return Integer vector of counts
bincounter <- function(x, bins) {
    .Call(`_R2sample_bincounter`, x, bins)
}

#' a local function needed for the vignette
#' 
#' @param x An integer vector.
#' @param y An integer vector.
#' @param vals A numeric vector with the values of the discrete rv.
#' @return A vector with test statistics
#' @export
myTS2 <- function(x, y, vals) {
    .Call(`_R2sample_myTS2`, x, y, vals)
}

#' run permutation test.
#' 
#' @param x a numeric vector.
#' @param y a numeric vector.
#' @param TS routine to calculate test statistics for non-chi-square tests 
#' @param typeTS type of a test statistic
#' @param TSextra additional info passed to TS, if necessary
#' @param wx a numeric vector of weights of x.
#' @param wy a numeric vector of weights of y.
#' @param B =5000, number of simulation runs.
#' @keywords internal
#' @return A list with test statistics and p values
perm_test_cont <- function(x, y, TS, typeTS, TSextra, wx, wy, B = 5000L) {
    .Call(`_R2sample_perm_test_cont`, x, y, TS, typeTS, TSextra, wx, wy, B)
}

#' run permutation test.
#' 
#' @param x A vector of counts or weights.
#' @param y A vector of counts or weights.
#' @param vals A numeric vector. Indicates discrete data.
#' @param TS routine to calculate test statistics for non-chi-square tests 
#' @param typeTS type of a test statistic
#' @param TSextra additional info passed to TS, if necessary
#' @param samplingmethod =1, 1 for independence sampling, 2 for MCMC
#' @param B Number of simulation runs.
#' @keywords internal
#' @return A list with test statistics and p values
perm_test_disc <- function(x, y, vals, TS, typeTS, TSextra, samplingmethod = 1L, B = 5000L) {
    .Call(`_R2sample_perm_test_disc`, x, y, vals, TS, typeTS, TSextra, samplingmethod, B)
}

#' permute discrete data
#' 
#' @param dta A list of numeric vectors.
#' @param samplingmethod  =2 , 1 for independence sampling by expansion or 2 for MCMC
#' @keywords internal
#' @return A list of permuted vectors
permute_disc <- function(dta, samplingmethod = 1L) {
    .Call(`_R2sample_permute_disc`, dta, samplingmethod)
}

#' Find the power of various discrete tests via permutation.
#' 
#' @param rxy a function that generates x and y data.
#' @param TS routine to calculate test statistics for non-chi-square tests
#' @param typeTS indicator for type of test statistics
#' @param TSextra additional info passed to TS, if necessary
#' @param alpha A numeric constant
#' @param B =c(1000, 1000) number of simulation runs for power and for p values
#' @param xparam  arguments for r1.
#' @param yparam  arguments for r2.
#' @keywords internal
#' @return A numeric matrix of powers
power_cont <- function(rxy, TS, typeTS, TSextra, alpha = 0.05, B = as.numeric( c(1000, 1000)), xparam = 0.0, yparam = 0.0) {
    .Call(`_R2sample_power_cont`, rxy, TS, typeTS, TSextra, alpha, B, xparam, yparam)
}

#' Find the power of various tests via permutation.
#' 
#' @param rxy a function that generates x and y data.
#' @param TS routine to calculate test statistics for non-chi-square tests 
#' @param typeTS indicator for type of test statistics
#' @param TSextra additional info passed to TS, if necessary
#' @param alpha A numeric constant
#' @param samplingmethod =2, 1 for independence sampling, 2 for MCMC in discrete data case
#' @param B Number of simulation runs.
#' @param xparam  arguments for r1.
#' @param yparam  arguments for r2.
#' @keywords internal
#' @return A numeric matrix of powers
power_disc <- function(rxy, TS, typeTS, TSextra, alpha = 0.05, samplingmethod = 2L, B = as.numeric( c(1000, 2000)), xparam = 0.0, yparam = 0.0) {
    .Call(`_R2sample_power_disc`, rxy, TS, typeTS, TSextra, alpha, samplingmethod, B, xparam, yparam)
}

#' cpp version of R routine rep
#' 
#' @param x numeric vector
#' @param times integer vector
#' @keywords internal
#' @return A numeric vector
repC <- function(x, times) {
    .Call(`_R2sample_repC`, x, times)
}

#' Find counts and/or sum of weights in bins. Useful for power calculations. Replaces hist command from R.
#' 
#' @param x numeric vector
#' @param bins numeric vector
#' @param w numeric vector of weights 
#' @keywords internal
#' @return sum of weights in bins
wbincounter <- function(x, bins, w) {
    .Call(`_R2sample_wbincounter`, x, bins, w)
}

#' find weights for several statistics for discrete data
#' 
#' @param dta A list with vectors x, y and vals.
#' @keywords internal
#' @return A vector of weights
weights <- function(dta) {
    .Call(`_R2sample_weights`, dta)
}

