% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/html_doc.r
\name{html_doc}
\alias{html_doc}
\title{Prints a HTML table, listing or plot to a a file or console}
\usage{
html_doc(
  text,
  out = NULL,
  show = TRUE,
  rtitle = "report",
  template = paste0(system.file(package = "R3port"), "/simple.html"),
  rendlist,
  css = paste0(system.file(package = "R3port"), "/style.css")
)
}
\arguments{
\item{text}{character vector to be placed within HTML document}

\item{out}{character with filename for the output HTML file (if NULL it will print to console)}

\item{show}{logical indicating if the resulting pdf file from the compiled tex file should be opened when created}

\item{rtitle}{string indicating the title of the output document}

\item{template}{character with file name of the template file to use}

\item{rendlist}{list with render items to be used for the template file (see (see \code{\link{whisker-package}}))}

\item{css}{character with name of the css style sheet to use, default use package style sheet}
}
\value{
The function returns a HTML file (or writes output to console)
}
\description{
This function makes a HTML document using output generated with functions in the R3port package
or any other HTML code available as vector. Basically it adds tags to a html template file and let's
the user select various options to customize the output.
}
\details{
This function is used as wrapper within multiple functions in the R3port package but is also convenient in case
  custom information should be placed within an output document
}
\examples{

txt <- "<h1>Example</h1>"
tbl <- "<table><tr><td id='fcol'>table data</td><td>for custom table</td></tr></table>"
add <- "<p>Including some additional text</p>"
\dontrun{
  html_doc(c(txt,tbl,add),out=tempfile(fileext=".html"))
}
}
\seealso{
\code{\link{ltx_doc}}
}
