% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_vectorstore.R
\name{create_vectorstore}
\alias{create_vectorstore}
\title{create_vectorstore.R Overview}
\usage{
create_vectorstore(
  db_path = ":memory:",
  overwrite = FALSE,
  embedding_dim = 1536
)
}
\arguments{
\item{db_path}{Path to the DuckDB file. Use ":memory:" for an in-memory DB.}

\item{overwrite}{Logical, whether to drop and recreate the table if it already exists.}

\item{embedding_dim}{Integer, the dimensionality of the embedding vectors.}
}
\value{
A DuckDB connection object.
}
\description{
Provides tools to:
- Embed page content using OpenAI API (with support for chunking)
- Create a DuckDB-based vector store with support for HNSW indexing and optional FTS
- Insert documents with embedding vectors
- Perform approximate nearest-neighbor search using DuckDB's vss extension

## Required Packages
The following packages are required. Install them with:
\code{install.packages(c("dplyr", "DBI", "duckdb", "httr", "jsonlite", "stringi"))}

Initializes or connects to a DuckDB instance and prepares a table to store embeddings.
Optionally wipes existing data and installs required extensions for vector search.
}
\note{
Only `create_vectorstore()` is exported for use.
}
