% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other_useful_functions.R
\name{plotHaploNetwork}
\alias{plotHaploNetwork}
\title{Function to plot haplotype network from the estimated results}
\usage{
plotHaploNetwork(
  estNetworkRes,
  traitName = NULL,
  blockName = NULL,
  plotNetwork = TRUE,
  subpopInfo = estNetworkRes$subpopInfo,
  saveName = NULL,
  saveStyle = "png",
  plotWhichMDS = 1:2,
  colConnection = c("grey40", "grey60"),
  ltyConnection = c("solid", "dashed"),
  lwdConnection = c(1.5, 0.8),
  pchBase = c(1, 16),
  colCompBase = c(2, 4),
  colHaploBase = c(3, 5, 6),
  cexMax = 2,
  cexMin = 0.7,
  ggPlotNetwork = FALSE,
  cexMaxForGG = 0.025,
  cexMinForGG = 0.008,
  alphaBase = c(0.9, 0.3)
)
}
\arguments{
\item{estNetworkRes}{The estimated results of haplotype network by `estNetwork` function for one}

\item{traitName}{Name of trait of interest. This will be used in the title of the plots.}

\item{blockName}{You can specify the haplotype block (or gene set, SNP-set) of interest by the name of haplotype block in `geno`.
This will be used in the title of the plots.}

\item{plotNetwork}{If TRUE, the function will return the plot of haplotype network.}

\item{subpopInfo}{The information of subpopulations.}

\item{saveName}{When drawing any plot, you can save plots in png format. In saveName, you should substitute the name you want to save.
When saveName = NULL, the plot is not saved.}

\item{saveStyle}{This argument specifies how to save the plot of phylogenetic tree.
The function offers `png`, `pdf`, `jpg`, and `tiff`.}

\item{plotWhichMDS}{We will show the MDS (multi-dimensional scaling) plot,
and this argument is a vector of two integers specifying that will define which MDS dimension will be plotted.
The first and second integers correspond to the horizontal and vertical axes, respectively.}

\item{colConnection}{A vector of two integers or characters specifying the colors of connection between nodes for the original and complemented haplotypes, respectively.}

\item{ltyConnection}{A vector of two characters specifying the line types of connection between nodes for the original and complemented haplotypes, respectively.}

\item{lwdConnection}{A vector of two integers specifying the line widths of connection between nodes for the original and complemented haplotypes, respectively.}

\item{pchBase}{A vector of two integers specifying the plot types for the positive and negative genotypic values respectively.}

\item{colCompBase}{A vector of two integers or characters specifying color of complemented haplotypes for the positive and negative genotypic values respectively.}

\item{colHaploBase}{A vector of integers or characters specifying color of original haplotypes for the positive and negative genotypic values respectively.
The length of the vector should equal to the number of subpopulations.}

\item{cexMax}{A numeric specifying the maximum point size of the plot.}

\item{cexMin}{A numeric specifying the minimum point size of the plot.}

\item{ggPlotNetwork}{If TRUE, the function will return the ggplot version of haplotype network.
It offers the precise information on subgroups for each haplotype.}

\item{cexMaxForGG}{A numeric specifying the maximum point size of the plot for the ggplot version of haplotype network,
relative to the range of x and y-axes (0 < cexMaxForGG <= 1).}

\item{cexMinForGG}{A numeric specifying the minimum point size of the plot for the ggplot version of haplotype network,
relative to the range of x and y-axes (0 < cexMaxForGG <= 1).}

\item{alphaBase}{alpha (parameter that indicates the opacity of a geom) for original haplotype with positive / negative effects.
alpha for complemented haplotype will be same as the alpha for original haplotype with negative effects.}
}
\value{
Draw plot of haplotype network.
}
\description{
Function to plot haplotype network from the estimated results
}
