% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bycbsa.R
\name{aqs_monitors_by_cbsa}
\alias{aqs_monitors_by_cbsa}
\title{aqs_monitors_by_cbsa}
\usage{
aqs_monitors_by_cbsa(
  parameter,
  bdate,
  edate,
  cbsa_code,
  cbdate = NA_Date_,
  cedate = NA_Date_,
  return_header = FALSE
)
}
\arguments{
\item{parameter}{a character list or a single character string
which represents the parameter code of the air
pollutant related to the data being requested.}

\item{bdate}{a R date object which represents that begin date of the data
selection. Only data on or after this date will be returned.}

\item{edate}{a R date object which represents that end date of the data
selection. Only data on or before this date will be returned.}

\item{cbsa_code}{a R character object which represents the 5 digit AQS Core
Based Statistical Area code (the same as the census code,
with leading zeros)}

\item{cbdate}{a R date object which represents a "beginning
date of last change" that indicates when the data was last
updated. cbdate is used to filter data based on the change
date. Only data that changed on or after this date will be
returned. This is an optional variable which defaults
to NA_Date_.}

\item{cedate}{a R date object which represents an "end
date of last change" that indicates when the data was last
updated. cedate is used to filter data based on the change
date. Only data that changed on or before this date will be
returned. This is an optional variable which defaults
to NA_Date_.}

\item{return_header}{If FALSE (default) only returns data requested. If TRUE
returns a AQSAPI_v2 object which is a two item list
that contains header information returned from the
API server mostly used for debugging purposes in
addition to the data requested.}
}
\value{
a tibble or an AQS_Data Mart_APIv2 S3 object that is the return value
from the AQS API. A AQS_Data Mart_APIv2 object is a 2 item named
list in which the first item (\$Header) is a tibble of header
information from the AQS API and the second item (\$Data) is a
tibble of the data returned.
}
\description{
\lifecycle{stable}
Returns a table of monitors at all sites with the provided
parameternum, aggregated by Core Based Statistical Area (CBSA) for
bdate - edate time frame.
}
\section{by_cbsa aggregate functions}{
NA
}

\examples{
# returns a tibble of NO2 monitors
          #  for Charlotte-Concord-Gastonia, NC cbsa that were operating
          #  on Janurary 01, 2017
          \dontrun{aqs_monitors_by_cbsa(parameter="42602",
                                               bdate=as.Date("20170101",
                                                           format="\%Y\%m\%d"),
                                               edate=as.Date("20170101",
                                                            format="\%Y\%m\%d"),
                                               cbsa_code="16740"
                                                   )
                   }
}
\seealso{
Other Aggregate _by_cbsa functions: 
\code{\link{aqs_annualsummary_by_cbsa}()},
\code{\link{aqs_dailysummary_by_cbsa}()},
\code{\link{aqs_sampledata_by_cbsa}()}
}
\concept{Aggregate _by_cbsa functions}
