% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bybox.R
\name{aqs_annualsummary_by_box}
\alias{aqs_annualsummary_by_box}
\title{aqs_annualsummary_by_box}
\usage{
aqs_annualsummary_by_box(
  parameter,
  bdate,
  edate,
  minlat,
  maxlat,
  minlon,
  maxlon,
  cbdate = NA_Date_,
  cedate = NA_Date_,
  return_header = FALSE
)
}
\arguments{
\item{parameter}{a character list or a single character string
which represents the parameter code of the air
pollutant related to the data being requested.}

\item{bdate}{a R date object which represents that begin date of the data
selection. Only data on or after this date will be returned.}

\item{edate}{a R date object which represents that end date of the data
selection. Only data on or before this date will be returned.}

\item{minlat}{a R character object which represents the minimum latitude of
a geographic box.  Decimal latitude with north begin
positive. Only data north of this latitude will be
returned.}

\item{maxlat}{a R character object which represents the maximum latitude of
a geographic box. Decimal latitude with north begin
positive. Only data south of this latitude will be
returned.}

\item{minlon}{a R character object which represents the minimum longitude
of a geographic box. Decimal longitude with east begin
positive. Only data east of this longitude will be
returned.}

\item{maxlon}{a R character object which represents the maximum longitude
of a geographic box. Decimal longitude with east begin
positive. Only data west of this longitude will be
returned. Note that -80 is less than -70.}

\item{cbdate}{a R date object which represents a "beginning date of last
change" that indicates when the data was last
updated. cbdate is used to filter data based on the change
date. Only data that changed on or after this date will be
returned. This is an optional variable which defaults
to NA_Date_.}

\item{cedate}{a R date object which represents an "end
date of last change" that indicates when the data was last
updated. cedate is used to filter data based on the change
date. Only data that changed on or before this date will be
returned. This is an optional variable which defaults
to NA_Date_.}

\item{return_header}{If FALSE (default) only returns data requested. If TRUE
returns a AQSAPI_v2 object which is a two item list that contains header
information returned from the API server mostly used for debugging
purposes in addition to the data requested.}
}
\value{
a tibble or an AQS_Data Mart_APIv2 S3 object that containing annual
summary data for the box (area) requested. A AQS_Data Mart_APIv2
is a 2 item named list in which the first item (\$Header) is a
tibble of header information from the AQS API and the second item
(\$Data) is a tibble of the data returned.
}
\description{
\lifecycle{stable}
Returns multiple years of data where annual data is
aggregated at the bounding box level. Returned is an annual
summary within the input parameter, latitude/longitude
bounding box provided for bdate - edate time frame. Variables
returned include mean value, maxima, percentiles, and etc. If
return_header is FALSE (default) the object returned is a
tibble, if TRUE an AQS_API_v2 object.
}
\note{
The AQS API only allows for a single year of annualsummary to be
retrieved at a time. This function conveniently extracts date
information from the bdate and edate parameters then makes repeated
calls to the AQSAPI retrieving a maximum of one calendar year of data
at a time. Each calendar year of data requires a separate API call so
multiple years of data will require multiple API calls. As the number
of years of data being requested increases so does the length of time
that it will take to retrieve results. There is also a 5 second wait
time inserted between successive API calls to prevent overloading the
API server. This operation has a linear run time of
/(Big O notation: O/(n + 5 seconds/)/).
}
\examples{
# returns a tibble containing ozone annual summaries
          #  in the vicinity of central Alabama for the first two days
          #  in May, 2015
          \dontrun{aqs_annualsummary_by_box(parameter = "44201",
                                            bdate = as.Date("20150501",
                                                          format = "\%Y\%m\%d"),
                                            edate = as.Date("20170502",
                                                          format = "\%Y\%m\%d"),
                                            minlat = "33.3",
                                            maxlat = "33.6",
                                            minlon = "-87.0",
                                            maxlon = "-86.7"
                                            )
                   }
}
\seealso{
Other Aggregate _by_box functions: 
\code{\link{aqs_monitors_by_box}()},
\code{\link{aqs_sampledata_by_box}()}
}
\concept{Aggregate _by_box functions}
