% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table.R
\name{sqlCreateTable}
\alias{sqlCreateTable}
\alias{sqlCreateTable,AthenaConnection-method}
\title{Creates query to create a simple Athena table}
\usage{
\S4method{sqlCreateTable}{AthenaConnection}(
  con,
  table,
  fields,
  field.types = NULL,
  partition = NULL,
  s3.location = NULL,
  file.type = c("tsv", "csv", "parquet", "json"),
  compress = FALSE,
  ...
)
}
\arguments{
\item{con}{A database connection.}

\item{table}{Name of the table. Escaped with
\code{\link[DBI:dbQuoteIdentifier]{dbQuoteIdentifier()}}.}

\item{fields}{Either a character vector or a data frame.

A named character vector: Names are column names, values are types.
Names are escaped with \code{\link[DBI:dbQuoteIdentifier]{dbQuoteIdentifier()}}.
Field types are unescaped.

A data frame: field types are generated using
\code{\link[DBI:dbDataType]{dbDataType()}}.}

\item{field.types}{Additional field types used to override derived types.}

\item{partition}{Partition Athena table (needs to be a named list or vector) for example: \code{c(var1 = "2019-20-13")}}

\item{s3.location}{s3 bucket to store Athena table, must be set as a s3 uri for example ("s3://mybucket/data/"). 
By default s3.location is set s3 staging directory from \code{\linkS4class{AthenaConnection}} object.}

\item{file.type}{What file type to store data.frame on s3, RAthena currently supports ["tsv", "csv", "parquet", "json"]. Default delimited file type is "tsv", in previous versions
of \code{RAthena (=< 1.6.0)} file type "csv" was used as default. The reason for the change is that columns containing \code{Array/JSON} format cannot be written to 
Athena due to the separating value ",". This would cause issues with AWS Athena.                  
\strong{Note:} "parquet" format is supported by the \code{arrow} package and it will need to be installed to utilise the "parquet" format.
"json" format is supported by \code{jsonlite} package and it will need to be installed to utilise the "json" format.}

\item{compress}{\code{FALSE | TRUE} To determine if to compress file.type. If file type is ["csv", "tsv"] then "gzip" compression is used, for file type "parquet" 
"snappy" compression is used. Currently \code{RAthena} doesn't support compression for "json" file type.}

\item{...}{Other arguments used by individual methods.}
}
\value{
\code{sqlCreateTable} returns data.frame's \code{DDL} in the \code{\link[DBI]{SQL}} format.
}
\description{
Creates an interface to compose \code{CREATE EXTERNAL TABLE}.
}
\examples{
\dontrun{
# Note: 
# - Require AWS Account to run below example.
# - Different connection methods can be used please see `RAthena::dbConnect` documnentation

library(DBI)

# Demo connection to Athena using profile name 
con <- dbConnect(RAthena::athena())
                 
# Create DDL for iris data.frame
sqlCreateTable(con, "iris", iris, s3.location = "s3://path/to/athena/table")

# Create DDL for iris data.frame with partition
sqlCreateTable(con, "iris", iris, 
               partition = "timestamp",
               s3.location = "s3://path/to/athena/table")
               
# Create DDL for iris data.frame with partition and file.type parquet
sqlCreateTable(con, "iris", iris, 
               partition = "timestamp",
               s3.location = "s3://path/to/athena/table",
               file.type = "parquet")

# Disconnect from Athena
dbDisconnect(con)
}
}
\seealso{
\code{\link[DBI]{sqlCreateTable}}
}
