% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/athena_low_api.R
\name{session_token}
\alias{session_token}
\alias{get_session_token}
\title{Get Session Tokens for Boto3 Connection}
\usage{
get_session_token(
  profile_name = NULL,
  region_name = NULL,
  serial_number = NULL,
  token_code = NULL,
  duration_seconds = 3600L,
  set_env = FALSE
)
}
\arguments{
\item{profile_name}{The name of a profile to use. If not given, then the default profile is used.
To set profile name, the \href{https://aws.amazon.com/cli/}{AWS Command Line Interface} (AWS CLI) will need to be configured.
To configure AWS CLI please refer to: \href{https://docs.aws.amazon.com/cli/latest/userguide/cli-chap-configure.html}{Configuring the AWS CLI}.}

\item{region_name}{Default region when creating new connections. Please refer to \href{https://docs.aws.amazon.com/general/latest/gr/rande.html}{link} for 
AWS region codes (region code example: Region = EU (Ireland)     \code{ region_name = "eu-west-1"})}

\item{serial_number}{The identification number of the MFA device that is associated with the IAM user who is making the GetSessionToken call.
Specify this value if the IAM user has a policy that requires MFA authentication. The value is either the serial number for a hardware device
(such as `GAHT12345678`) or an Amazon Resource Name (ARN) for a virtual device (such as arn:aws:iam::123456789012:mfa/user).}

\item{token_code}{The value provided by the MFA device, if MFA is required. If any policy requires the IAM user to submit an MFA code, 
specify this value. If MFA authentication is required, the user must provide a code when requesting a set of temporary
security credentials. A user who fails to provide the code receives an "access denied" response when requesting resources 
that require MFA authentication.}

\item{duration_seconds}{The duration, in seconds, that the credentials should remain valid. Acceptable duration for IAM user sessions range
from 900 seconds (15 minutes) to 129,600 seconds (36 hours), with 3,600 seconds (1 hour) as the default.}

\item{set_env}{If set to \code{TRUE} environmental variables \code{AWS_ACCESS_KEY_ID}, \code{AWS_SECRET_ACCESS_KEY} and \code{AWS_SESSION_TOKEN} will be set.}
}
\value{
\code{get_session_token()} returns a list containing: \code{"AccessKeyId"}, \code{"SecretAccessKey"}, \code{"SessionToken"} and \code{"Expiration"}
}
\description{
Returns a set of temporary credentials for an AWS account or IAM user (\href{https://boto3.amazonaws.com/v1/documentation/api/latest/reference/services/sts.html#STS.Client.get_session_token}{link}).
}
\examples{
\dontrun{
# Note: 
# - Require AWS Account to run below example.

library(RAthena)
library(DBI)

# Create Temporary Credentials duration 1 hour
get_session_token("YOUR_PROFILE_NAME",
                  serial_number='arn:aws:iam::123456789012:mfa/user',
                  token_code = "531602",
                  set_env = TRUE)

# Connect to Athena using temporary credentials
con <- dbConnect(athena())
}
}
