% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RBMRB.R
\name{convert_cs_to_tocsy}
\alias{convert_cs_to_tocsy}
\title{Reformats chemical shift dataframe for easy plotting}
\usage{
convert_cs_to_tocsy(csdf)
}
\arguments{
\item{csdf}{chemical shift data frame from \link{fetch_entry_chemical_shifts}}
}
\value{
R data frame that contains all possible combinations of proton chemical shifts in two columns
}
\description{
Reformats the output dataframe from \link{fetch_entry_chemical_shifts} into a simple dataframe that contains algorithmically combined proton shifts in two columns.
This will be helpful to plot TOCSY(TOtal Correlation SpectroscpY) spectrum
}
\examples{
df<-fetch_entry_chemical_shifts(15060)
# Downloads data from BMRB
tocsy<-convert_cs_to_tocsy(df)
# Reformats for easy plotting
}
\seealso{
\code{\link{convert_cs_to_c13hsqc}} and \code{\link{convert_cs_to_n15hsqc}}
}
