% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Links.R
\name{links_Expand}
\alias{links_Expand}
\title{Given a bitly URL or hash (or multiple), returns the target (long) URL.}
\usage{
links_Expand(hashIN = NULL, shortUrl = NULL, showRequestURL = FALSE)
}
\arguments{
\item{hashIN}{- refers to one bitly hashes, (e.g.:  2bYgqR or a-custom-name). Required}

\item{shortUrl}{- refers to one Bitlinks e.g.: http://bit.ly/1RmnUT or http://j.mp/1RmnUT. Optional.}

\item{showRequestURL}{- show URL which has been build and requested from server. For debug purposes.}
}
\value{
short_url - this is an echo back of the shortUrl request parameter.

hash - this is an echo back of the hash request parameter.

user_hash - the corresponding bitly user identifier.

global_hash - the corresponding bitly aggregate identifier.

error - indicates there was an error retrieving data for a given shortUrl or hash. An
example error is "NOT_FOUND".

long_url - the URL that the requested short_url or hash points to.
}
\description{
Given a bitly URL or hash (or multiple), returns the target (long) URL.
}
\note{
Either shortUrl or hash must be given as a parameter.

The maximum number of shortUrl and hash parameters is 15.
}
\section{TODO}{
 or more URLs  Up TO 15
}
\examples{
rbitlyApi("0906523ec6a8c78b33f9310e84e7a5c81e500909")
links_Expand(shortUrl = "http://bit.ly/DPetrov")
links_Expand(hash = "DPetrov", showRequestURL = TRUE)
links_Expand(hash = "DPetrov")
links_Expand(shortUrl = "on.natgeo.com/1bEVhwE", hash = "1bEVhwE")

## manyHashes <- list("DPetrov", "1QU8CFm", "1R1LPSE", "1LNqqva")
## for (u in 1:length(manyHashes)) {
##   print(links_Expand(hashIN = manyHashes[[u]], showRequestURL = TRUE))
## }
}
\seealso{
See \url{http://dev.bitly.com/links.html#v3_expand}
}

