% Generated by roxygen2 (4.0.1): do not edit by hand
\name{checkTimePeriod}
\alias{checkTimePeriod}
\title{Check for continuous time periods in CMIP5 files}
\usage{
checkTimePeriod(fileInfo_df)
}
\arguments{
\item{fileInfo_df}{data.frame from getFileInfo}
}
\value{
A data frame showing which ensembles are continuous, and which are not.
In addition to standard identifying fields in the data frame (domain, model,
experiment, variable, and ensemble), this includes:
 \item{yrStr}{A concatenation of time strings for all ensembles}
 \item{allHere}{a quick check for yr and mon frequency}
 \item{startDate}{Earliest (decimal) date for the ensemble}
 \item{endDate}{Latest (decimal) date for the ensemble}
 \item{file}{The number of files in the ensemble}
}
\description{
Check that all time periods are continuous and present for multi-file ensembles.
Before starting to process what may be hundreds or thousands of CMIP5 files,
it's a good idea to verify that your file set is complete and not missing any
years.
}
\details{
This function calls \code{\link{getFileInfo}} to scan a directory tree,
and then examines the time data in these filenames. These time signatures
will be concatenated and an 'allHere' flag returned.
}
\note{
This only works for files that are in domains 'fx', 'mon', or 'yr'.
Decimal time is (year + (month-1)/12).

Unfortunately it's impossible to automatically check the time signature for
sub-monthly frequencies quickly without opening the netcdf file.
}
\examples{
\dontrun{
checkTimePeriod(getFileInfo())
}
}
\seealso{
\code{\link{getFileInfo}}
}

