% Generated by roxygen2 (4.0.1): do not edit by hand
\name{filterDimensions}
\alias{filterDimensions}
\title{Filter dimensions, limiting to arbitrary lon/lat/Z/time}
\usage{
filterDimensions(x, lons = NULL, lats = NULL, Zs = NULL, years = NULL,
  months = NULL, verbose = FALSE)
}
\arguments{
\item{x}{A \code{\link{cmip5data}} object}

\item{lons}{numeric vector. Longitudes to filter}

\item{lats}{numeric vector. Latitudes to filter}

\item{Zs}{numeric vector. Z values to filter}

\item{years}{numeric vector}

\item{months}{numeric vector}

\item{verbose}{logical. Print info as we go?}
}
\value{
The filtered \code{\link{cmip5data}} object.
}
\description{
We frequently want to filter CMIP5 data according to some predetermined
criteria: only high-latitude cells, for example, or certain years, months,
Zs, etc. This function provides convenient one-stop service
for such filtering.
}
\note{
If a filter is requested but no relevant data are present,
a \code{\link{warning}} will be produced.
}
\examples{
d <- cmip5data(1970:2014)   # sample data
filterDimensions(d, years=1980:1985)
filterDimensions(d, months=6:8)  # summer
filterDimensions(d, lats=d$lat[abs(d$lat)<20])  # the tropics
}

