% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-volcano.R
\name{plotVolcanoDE}
\alias{plotVolcanoDE}
\title{Plot volcano plot from Pathway analysis results}
\usage{
plotVolcanoDE(DEResult, pThreshold = 0.05, useFDR = TRUE, logFCThreshold = 1)
}
\arguments{
\item{DEResult}{A data frame with Pathway analysis results.
The columns are ID, name, description, p.value, pFDR, size, nDE, score and normalizedScore.}

\item{pThreshold}{The p-value threshold to use for the horizontal line.}

\item{useFDR}{Whether to use the pFDR column instead of the p.value column.}

\item{logFCThreshold}{The logFC threshold to use for the vertical line.}
}
\value{
A ggplot2 object.
}
\description{
Plot volcano plot from Pathway analysis results
}
\examples{
\donttest{

library(RCPA)
library(SummarizedExperiment)

affyDEExperiment <- loadData("affyDEExperiment")
agilDEExperiment <- loadData("agilDEExperiment")
RNASeqDEExperiment <- loadData("RNASeqDEExperiment")

RCPA::plotVolcanoDE(rowData(affyDEExperiment), logFCThreshold = 0.5) +
    ggplot2::ggtitle("Affymetrix - GSE5281")
RCPA::plotVolcanoDE(rowData(agilDEExperiment), logFCThreshold = 0.5) +
    ggplot2::ggtitle("Agilent - GSE61196")
RCPA::plotVolcanoDE(rowData(RNASeqDEExperiment), logFCThreshold = 0.5) +
    ggplot2::ggtitle("RNASeq - GSE153873")

}
}
