% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/histC.r
\name{histC}
\alias{histC}
\title{Creates histogram to show distribution of interval (numeric) variable's values}
\usage{
histC(x, w, data, breaks, digits = 2, printC = FALSE, plot = TRUE, main,
  xlab, ylab, bar.col, ...)
}
\arguments{
\item{x}{The variable to be analyzed. If dataset not specified with data argument, should be a vector in form dataset$var.}

\item{w}{(Optional) Sample weights (must be numeric if used), If dataset not specified with data argument, should be in form dataset$weighvar}

\item{data}{(Optional) Name of dataset that contains x (and w) variable.}

\item{breaks}{(Optional) Specify how to break the x variable into bins. Options include the number of breaks, a vector specifying the breakpoints, or the name of an algorithm that generates breakpoints. Default value is "Sturges" (other algorithms are "Scott" and "FD", see details in \code{\link[weights]{wtd.hist}} documentation).}

\item{digits}{(Optional) Number of digits to display after decimal points (default is 2).}

\item{printC}{(Optional) Do you want the histogram and binned frequencies table printed to working directory? (default: FALSE)}

\item{plot}{(Optional) Do you want the histogram graphic? (default: TRUE)}

\item{main}{(Optional) Customize main title for histogram.}

\item{xlab}{(Optional) Custom label for x-axis of histogram.}

\item{ylab}{(Optional) Custom label for y-axis of histogram.}

\item{bar.col}{(Optional) Color for histogram bars; default is "gray80".}

\item{...}{(Optional) Additional arguments passed to \code{weights::wtd.hist} function.}
}
\value{
A frequency distribution table of binned x variable values.
}
\description{
Generates frequency distribution table of binned values and a histogram to describe distribution of variable values.
}
\section{Textbook References}{

\itemize{
\item Philip H. Pollock and Barry C. Edwards, \emph{An R Companion to Political Analysis, 3rd Edition} (Thousand Oaks, CA: Sage Publications, Forthcoming 2022), Chapter 2.
\item Philip H. Pollock and Barry C. Edwards, \emph{The Essentials of Political Analysis, 6th Edition} (Thousand Oaks, CA: Sage Publications, 2020), pp. 39-55. ISBN-13: 978-1506379616; ISBN-10: 150637961.
}
}

\section{Online Resources}{

\itemize{
\item \href{https://www.poliscidata.com/pages/rDemosResources.php?chapter=2}{R Tutorials & Resources for Descriptive Statistics}, Compiled by Barry C. Edwards
\item \href{https://edge.sagepub.com/pollock}{Sage Edge Resources for Political Analysis Series}, for streaming videos, flashcards, and more student resources for textbooks by Pollock and Edwards, from Sage Publications.
\item \href{https://www.poliscidata.com}{Political Science Data Web Site}: Find datasets for your own research and resources to help with the analysis.
}
}

\examples{
   library(RCPA3)
   
   histC(x=states$covid.cases.per1000)
   
}
