% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/welcome.r
\name{welcome}
\alias{welcome}
\title{Welcomes new users to package with basic information, option to reset user's working environment}
\usage{
welcome(reset = FALSE)
}
\arguments{
\item{reset}{(Optional) Do you want to remove objects from your workspace and restore default graphical parameters? Default is FALSE. Removing workspace objects and restoring default graphical parameters can help undo some unintended side-effects of past work.}
}
\value{
No value returned
}
\description{
Welcomes users to RCPA3 package for \emph{An R Companion to Political Analysis, 3rd Edition} and provides basic information about using Companion functions and datasets.
}
\section{RCPA3 Package Tutorial Videos}{

\itemize{
\item \href{https://www.youtube.com/playlist?list=PL3jY4WDTUxoNqrxSSQH4q7XPLPYipeNCu}{Complete Playlist of RCPA3 Package Tutorial Videos}, includes video for this function and many more.
}
}

\section{Textbook Reference}{

\itemize{
\item Philip H. Pollock and Barry C. Edwards, \emph{An R Companion to Political Analysis, 3rd Edition} (Thousand Oaks, CA: Sage Publications, Forthcoming 2022), Chapter 1.
}
}

\section{Online Resources}{

\itemize{
\item \href{https://www.poliscidata.com/pages/rDemosResources.php?chapter='I'}{R Tutorials & Resources for Getting Started with R}, Compiled by Barry C. Edwards
\item \href{https://edge.sagepub.com/pollock}{Sage Edge Resources for Political Analysis Series}, for streaming videos, flashcards, and more student resources for textbooks by Pollock and Edwards, from Sage Publications.
}
}

\examples{
 
  library(RCPA3)
  
  # Welcome message from RCPA3 package.
  \dontrun{
  welcome()
  }
}
