% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MainFunctions.R
\name{NeigRepresent}
\alias{NeigRepresent}
\title{Calculate the neighbor representation of cells to the low-dimensional 
gene expression matrix}
\usage{
NeigRepresent(
  drData,
  NN.method = "KNN",
  Dis.method = "Euclidean",
  LSH.TreeNum = 30,
  LSH.Dim = 500,
  LSH.Dis = "angular",
  neiRatio = 0.65
)
}
\arguments{
\item{drData}{gene expression matrix after dimensionality reduced by PCA}

\item{NN.method}{the method of finding neighbors}

\item{Dis.method}{the distance metric in finding neighbors}

\item{LSH.TreeNum}{the tree number of LSH}

\item{LSH.Dim}{the dimension in LSH}

\item{LSH.Dis}{the distance metric in LSH}

\item{neiRatio}{ratio of the number of selected}
}
\value{
the similarity matrix measured by neighbor representation NR
}
\description{
Calculate the neighbor representation of cells to the low-dimensional 
gene expression matrix
}
\examples{
gfData <- GenesFilter(yan[1:100,1:15])
res_SimS <- SimS(gfData)
NeigRepresent(res_SimS$drData)

}
