% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotFunctions.R
\name{PlotMST}
\alias{PlotMST}
\title{Plot the visualization of constructed Minimum Spanning Tree based on the clustering results of RCSL}
\usage{
PlotMST(
  drData,
  clustRes,
  TrueLabel,
  dataName = "",
  fontSize = 12,
  VisualMethod = "umap"
)
}
\arguments{
\item{drData}{preprocessed gene expression data}

\item{clustRes}{the clustering results identified by RCSL}

\item{TrueLabel}{the real cell types to color the dots in plot}

\item{dataName}{the name of the data that will be showed in the plot}

\item{fontSize}{the font size of the plot}

\item{VisualMethod}{the method for 2D visualization including UMAP,t-SNE and PCA}
}
\value{
MSTPlot ggplot object of the visualization of constructed MST
}
\description{
Plot the visualization of constructed Minimum Spanning Tree based on the clustering results of RCSL
}
\examples{
gfData <- GenesFilter(yan[1:100,1:15])
TrueLabel <- ann$cell_type1[1:15]
res_SimS <- SimS(gfData)
C <- EstClusters(res_SimS$drData,res_SimS$S)
res_BDSM <- BDSM(res_SimS$S,C)
PlotMST(res_SimS$drData,res_BDSM$y,TrueLabel)

}
