% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treatment_assign.R
\name{ntile_label}
\alias{ntile_label}
\title{ntile_label() ranks observations in n groups, with labels}
\usage{
ntile_label(var, n, digits = 0)
}
\arguments{
\item{var}{The variable wished to be ntile_label}

\item{n}{rank the variable in n groups}

\item{digits}{How many digits to include in the label}
}
\value{
A ordered factor vector of each n group. The value has the form of [min(n_i) - max(n_i)]
}
\description{
ntile_label() ranks observations in n groups, with labels
}
\details{
n_tile_label is very similar to ntile from dplyr. But n_tile_label creates
the n groups and then labels them. For each group i, the value of the ntile_label is 
[min(i) - max(i)].
}
\examples{
data <- data.frame(y_1 = rbinom(n = 100, size = 1, prob = 0.3), 
                   y_2 = rnorm(n = 100, mean = 8, sd = 2))
data$y_1_2 <- ntile_label(data$y_1, n = 2, digits = 0) 
data$y_2_4 <- ntile_label(data$y_2, n = 4)
}
