% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/volebni_okrsky.R
\name{volebni_okrsky}
\alias{volebni_okrsky}
\title{Election Districts (Volební okrsky) of the Czech Republic}
\source{
© ČÚZK, 2023 \url{https://vdp.cuzk.cz/}
}
\usage{
volebni_okrsky(resolution = "high")
}
\arguments{
\item{resolution}{Should the function return high or low resolution shapefile? Allowed values are "high" (default) and "low". This parameter affects only the geometry column, all other fields remain the same.}
}
\value{
\code{sf} data frame with 14 733 rows of 6 variables + geometry

\describe{
\item{Kod}{Unique id of the district.}
\item{Cislo}{Id of the district within a given Obec / not globally unique.}
\item{ObecKod}{Id of obec - maps to obce_polygony()$KOD_OBEC.}
\item{MomcKod}{Id of městská část - maps to casti()$KOD.}
\item{KOD_LAU1}{Id of okres - maps to okresy()$KOD_LAU1.}
\item{KOD_CZNUTS3}{Id of kraj - maps to kraje()$KOD_CZNUTS3.}
}
}
\description{
Function returning data frame of the local election districts for the Czech Republic as \code{sf} polygons. It takes a single parameter resolution - high res (default) or low res polygons.
}
\details{
Due to package size constraints the data are stored externally (and a working internet connection is required to use the package).

The data is current to January 2023 (the presidential elections). Downloaded size of high resolution shapefile is 75 MB, size of the low res object is 5 MB (so proceed with caution, and patience).
}
\examples{
\donttest{
 library(sf)

prazske_okrsky <- subset(volebni_okrsky("low"), ObecKod == "554782")
plot(prazske_okrsky) # the districts of Prague
}
}
