% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vyskopis.R
\name{vyskopis}
\alias{vyskopis}
\title{Vyskopis}
\format{
\code{raster} package RasterLayer.
}
\source{
\url{https://www.arcdata.cz/produkty/geograficka-data/arccr-500}
}
\usage{
vyskopis(format = "rayshaded")
}
\arguments{
\item{format}{Should the function return actual relief (meters above sea level) or shaded relief (rayshaded). Allowed values are "actual" and "rayshaded".}
}
\description{
Terrain of the Czech Republic as a {raster} package object.
}
\details{
The function returns a raster file of either actual relief (values are meters above sea level) or rayshaded relief (created via highly recommended {rayshader} package).

The raster is 5084 by 3403 cells, meaning each pixel is about 90 × 90 meters. It works the best at level of country or regions, at the level of a city or lower it may be somewhat grainy.

Due to package size constraints both versions are stored externally (and a working internet connection is required to use the package). Downloaded size of the rayshaded raster is 8.4 MB, actual raster is 31.4 MB.
}
\examples{

library(raster)

relief <- vyskopis("rayshaded")

plot(relief, col = gray.colors(16))
}
