\name{REAT-package}
\alias{REAT-package}
\alias{REAT}
\docType{package}
\title{
Regional Economic Analysis Toolbox
}
\description{
In regional and urban economics and economic geography, very frequent research fields are the existence and evolution of agglomerations due to (internal and external) agglomeration economies, regional economic growth and regional disparities, where these concepts and relationships are closely related to each other (Capello/Nijkamp 2009, Dinc 2015, Farhauer/Kroell 2013, McCann/van Oort 2009). Also accessibility and spatial interaction modeling is mostly regarded as related to these disciplines (Aoyama et al. 2011, Guessefeldt 1999). The group of the related analysis methods is sometimes summarized by the term \emph{regional analysis} or \emph{regional economic analysis} (Dinc 2015, Guessefeldt 1999, Isard 1960). 

This package contains a collection of models and analysis methods used in regional and urban economics and (quantitative) economic geography. The functions in this package can be divided in seven groups: 

(1) analysis of regional disparities and inequality, including \emph{Gini coefficient}, the \emph{Lorenz curve} and the \emph{(weighted) coefficient of variation}

(2) specialization of regions, including \emph{spatial Gini coefficient of regional specialization} and \emph{Krugman coefficient for regional specialization}

(3) spatial concentration of industries, including \emph{location quotients} and \emph{spatial Gini coefficient for industry concentration}

(4) regional growth and convergence, including traditional \emph{shift-share analysis} and \emph{analysis of beta and sigma convergence for cross-sectional data}

(5) spatial interaction and accessibility models, including \emph{Huff Model} and \emph{Hansen accessibility}

(6) proximity analysis, including calculation of \emph{distance matrices} and \emph{buffers} 

(7) additional tools for data preparation und visualization. 

The package also contains data examples. 
}

\author{
Thomas Wieland

Maintainer: Thomas Wieland \email{thomas.wieland.geo@googlemail.com}
}

\references{
Aoyama, Y./Murphy, J. T./Hanson, S. (2011): \dQuote{Key Concepts in Economic Geography}. London: SAGE.

Capello, R./Nijkamp, P. (2009): \dQuote{Introduction: regional growth and development theories in the twenty-first century - recent theoretical advances and future challenges}. In: Capello, R./Nijkamp, P. (eds.): \emph{Handbook of Regional Growth and Development Theories}. Cheltenham: Elgar. p. 1-16.

Dinc, M. (2015): \dQuote{Introduction to Regional Economic Development. Major Theories and Basic Analytical Tools}. Cheltenham: Elgar. 

Farhauer, O./Kroell, A. (2013): \dQuote{Standorttheorien: Regional- und Stadtoekonomik in Theorie und Praxis}. Wiesbaden: Springer.

Guessefeldt, J. (1999): \dQuote{Regionalanalyse}. Muenchen: Oldenbourg.

Isard, W. (1960): \dQuote{Methods of Regional Analysis: an Introduction to Regional Science}. Cambridge: M.I.T. Press.

McCann, P./van Oort, F. (2009): \dQuote{Theories of agglomeration and regional economic growth: a historical review}. In: Capello, R./Nijkamp, P. (eds.): \emph{Handbook of Regional Growth and Development Theories}. Cheltenham: Elgar. p. 19-32.
}