% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/GVmix.R
\name{GVmix}
\alias{GVmix}
\title{NPMLE for Gaussian Variance Heterogeneity}
\usage{
GVmix(x, m, v = 300, weights = NULL, ...)
}
\arguments{
\item{x}{vector of observed variances}

\item{m}{vector of sample sizes corresponding to x}

\item{v}{A vector of bin boundaries, if scalar then v equally spaced bins
are constructed}

\item{weights}{replicate weights for x obervations, should sum to 1}

\item{...}{optional parameters passed to KWDual to control optimization}
}
\value{
An object of class \code{density} with components:
	\item{x}{midpoints of the bin boundaries}
	\item{y}{estimated function values of the mixing density}
	\item{g}{function values of the mixture density at the observed x's.}
	\item{logLik}{the value of the log likelihood at the solution}
	\item{dy}{Bayes rule estimates of }
	\item{status}{the Mosek convergence status.}
}
\description{
A Kiefer-Wolfowitz MLE for Gaussian models with independent variances.  This
can be viewed as a general form for \eqn{\chi^2} mixtures, see \code{Gammamix}
for a more general form for Gamma mixtures.
}
\author{
R. Koenker
}
\references{
Koenker, R and I. Mizera, (2013) ``Convex Optimization, Shape Constraints,
Compound Decisions, and Empirical Bayes Rules,'' \emph{JASA}, 109, 674--685.

Gu J. and R. Koenker (2014) Unobserved heterogeneity in
income dynamics: an empirical Bayes perspective, \emph{JBES}, forthcoming.
}
\seealso{
Gammamix for a general implementation for Gamma mixtures
}
\keyword{nonparametric}

