% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redcap-read-dag.R
\name{redcap_dag_read}
\alias{redcap_dag_read}
\title{Read data access groups from a REDCap project}
\usage{
redcap_dag_read(
  redcap_uri,
  token,
  http_response_encoding = "UTF-8",
  locale = readr::default_locale(),
  verbose = TRUE,
  config_options = NULL
)
}
\arguments{
\item{redcap_uri}{The URI (uniform resource identifier) of the REDCap
project.  Required.}

\item{token}{The user-specific string that serves as the password for a
project.  Required.}

\item{http_response_encoding}{The encoding value passed to
\code{\link[httr:content]{httr::content()}}.  Defaults to 'UTF-8'.}

\item{locale}{a \code{\link[readr:locale]{readr::locale()}} object to specify preferences like
number, date, and time formats.  This object is passed to
\code{\link[readr:read_delim]{readr::read_csv()}}.  Defaults to \code{\link[readr:locale]{readr::default_locale()}}.}

\item{verbose}{A boolean value indicating if \code{message}s should be printed
to the R console during the operation.  The verbose output might contain
sensitive information (\emph{e.g.} PHI), so turn this off if the output might
be visible somewhere public. Optional.}

\item{config_options}{A list of options to pass to \code{POST} method in the
\code{httr} package.}
}
\value{
Currently, a list is returned with the following elements:
\itemize{
\item \code{data}: An R \code{\link[base:data.frame]{base::data.frame()}} of all data access groups of the project.
\item \code{success}: A boolean value indicating if the operation was apparently
successful.
\item \code{status_codes}: A collection of
\href{https://en.wikipedia.org/wiki/List_of_HTTP_status_codes}{http status codes},
separated by semicolons.  There is one code for each batch attempted.
\item \code{outcome_messages}: A collection of human readable strings indicating the
operations' semicolons.  There is one code for each batch attempted.  In an
unsuccessful operation, it should contain diagnostic information.
\item \code{elapsed_seconds}: The duration of the function.
}
}
\description{
This function reads all available data access groups from
REDCap an returns them as a \code{\link[base:data.frame]{base::data.frame()}}.
}
\examples{
\dontrun{
uri     <- "https://bbmc.ouhsc.edu/redcap/api/"
token   <- "9A81268476645C4E5F03428B8AC3AA7B"
REDCapR::redcap_dag_read(redcap_uri=uri, token=token)$data
}
}
\references{
The official documentation can be found on the 'API Help Page'
and 'API Examples' pages on the REDCap wiki (\emph{i.e.},
https://community.projectredcap.org/articles/456/api-documentation.html
and
https://community.projectredcap.org/articles/462/api-examples.html).
If you do not have an account for the wiki, please ask your campus REDCap
administrator to send you the static material.
}
\author{
Jonathan M. Mang
}
