% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_redcap.R
\name{get_repeat_event_types}
\alias{get_repeat_event_types}
\title{Add identification for repeat event types}
\usage{
get_repeat_event_types(data)
}
\arguments{
\item{data}{the REDCap data}
}
\value{
A dataframe with unique event names mapped to their corresponding repeat types
}
\description{
To correctly assign repeat event types a few assumptions must be made:
\itemize{
\item There are only 3 behaviors: nonrepeating, repeat_separately, and repeat_together
\item If an event only shows \code{redcap_repeat_instance} and \code{redcap_repeat_instrument}
as \code{NA}, it can be considered a nonrepeat event.
\item If an event is always \code{NA} for \code{redcap_repeat_instrument} and filled for \code{redcap_repeat_instance}
it can be assumed to be a repeat_together event
\item repeat_separate and nonrepeating event types exhibit the same behavior along the
primary keys of the data. nonrepeating event types can have data display with
\code{redcap_repeat_instance}values both filled and as \code{NA}. If this is the case,
it can be assumed the event is a repeating separate event.
}
}
\keyword{internal}
