% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.REMLA.R
\name{summary.REMLA}
\alias{summary.REMLA}
\title{Summary for Robust Estimation Maximization}
\usage{
\method{summary}{REMLA}(object, ...)
}
\arguments{
\item{object}{an object of class "REMLA", usually a result of a call to \link{REM_EFA}.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
The summary.REM function returns estimated parameters from the optimal model based on the BIC from the EM and REM algorithms.

Output include:
\item{optimal}{optimal number of factors based on BIC}
\item{mu}{intercept}
\item{lambda}{loadings}
\item{psi}{variance}
\item{indk_lik}{likelihood value for each individual}
\item{epsilon}{hyperparameter on the likelihood scale}
\item{diff}{differences between EM and REM}
}
\description{
Summary method for class "REMLA".
}
\references{
Nieser, K. J., & Cochran, A. L. (2021). Addressing heterogeneous populations in latent variable settings through robust estimation. Psychological Methods.
}
\seealso{
the model fitting function \code{\link[=REM_EFA]{REM_EFA()}}, \code{\link[=summary]{summary()}}.
}
\author{
Bryan Ortiz-Torres (bortiztorres@wisc.edu); Kenneth Nieser (nieser@wisc.edu)
}
