/*
 * Decompiled with CFR 0.152.
 */
package epp_pso;

import indice.Indice;
import javalain.math.Calcul;
import math.Matrice;
import util.GuiUtils;

public class Particule {
    private final Indice indice;
    private final int P;
    private double I;
    public double meilleurI;
    public double[] projectionCourante;
    public double[] meilleureProjection;
    public double[] meilleureProjectionVoisine;
    private double[] vitesse;

    public Particule(Indice ind) {
        this.indice = ind;
        this.P = ind.getNombreParametres();
        this.projectionCourante = new double[this.P];
        this.vitesse = new double[this.P];
        this.meilleureProjection = new double[this.P];
        this.meilleureProjectionVoisine = new double[this.P];
        for (int i = 0; i < this.P; ++i) {
            this.projectionCourante[i] = Math.random() * 2.0 - 1.0;
            this.vitesse[i] = Math.random() * 2.0 - 1.0;
            this.meilleureProjection[i] = 0.0;
            this.meilleureProjectionVoisine[i] = 0.0;
        }
        this.projectionCourante = Calcul.normaliseVecteur((double[])this.projectionCourante);
        this.meilleurI = Double.NEGATIVE_INFINITY;
    }

    public void calculMeilleurePosition() {
        this.I = this.indice.calcul(this.projectionCourante);
        if (this.I > this.meilleurI) {
            this.meilleurI = this.I;
            for (int k = 0; k < this.P; ++k) {
                this.meilleureProjection[k] = this.projectionCourante[k];
            }
        }
    }

    public void calculNouvellePosition() {
        double c1 = 0.7;
        double Cmax = 1.43;
        Matrice AA = new Matrice(this.P);
        Matrice BB = new Matrice(this.P);
        for (int i = 0; i < this.P; ++i) {
            for (int j = 0; j < this.P; ++j) {
                if (i == j) {
                    AA.setElement(i, i, Cmax * Math.random());
                    BB.setElement(i, i, Cmax * Math.random());
                    continue;
                }
                AA.setElement(i, j, 0.0);
                BB.setElement(i, j, 0.0);
            }
        }
        for (int i = 0; i < this.P; ++i) {
            double v = c1 * this.vitesse[i];
            if (v > 1.0) {
                v = 1.0;
            } else if (v < -1.0) {
                v = -1.0;
            }
            this.vitesse[i] = v + AA.element(i, i) * (this.meilleureProjection[i] - this.projectionCourante[i]) + BB.element(i, i) * (this.meilleureProjectionVoisine[i] - this.projectionCourante[i]);
            if (this.vitesse[i] > 1.0) {
                this.vitesse[i] = 1.0;
            } else if (this.vitesse[i] < -1.0) {
                this.vitesse[i] = -1.0;
            }
            int n = i;
            this.projectionCourante[n] = this.projectionCourante[n] + this.vitesse[i];
        }
        this.projectionCourante = Calcul.normaliseVecteur((double[])this.projectionCourante);
    }

    public String toString() {
        int i;
        StringBuilder s = new StringBuilder();
        s.append("----- Particule (n = ").append(this.P).append(")\n");
        s.append("I                    : ").append(GuiUtils.DECIMAL_12.format(this.I)).append("\n");
        s.append("Meilleur I           : ").append(GuiUtils.DECIMAL_12.format(this.meilleurI)).append("\n");
        s.append("Projection courante  : ");
        for (i = 0; i < this.P - 1; ++i) {
            s.append(GuiUtils.DECIMAL_12.format(this.projectionCourante[i])).append(", ");
        }
        s.append(GuiUtils.DECIMAL_12.format(this.projectionCourante[this.P - 1])).append("\n");
        s.append("Meilleure projection : ");
        for (i = 0; i < this.P - 1; ++i) {
            s.append(GuiUtils.DECIMAL_12.format(this.meilleureProjection[i])).append(", ");
        }
        s.append(GuiUtils.DECIMAL_12.format(this.meilleureProjection[this.P - 1])).append("\n");
        s.append("Meilleure voisine    : ");
        for (i = 0; i < this.P - 1; ++i) {
            s.append(GuiUtils.DECIMAL_12.format(this.meilleureProjectionVoisine[i])).append(", ");
        }
        s.append(GuiUtils.DECIMAL_12.format(this.meilleureProjectionVoisine[this.P - 1])).append("\n");
        s.append("-----");
        return s.toString();
    }
}

