/*
 * Decompiled with CFR 0.152.
 */
package ihm;

import epp.EPPLab;
import epp.EvolutionPP;
import epp.ParametrePP;
import ihm.Bienvenue;
import ihm.Ihm;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javalain.algorithmegenetique.ihm.composant.JButtonEA;
import javalain.algorithmegenetique.ihm.composant.JCheckBoxEA;
import javalain.algorithmegenetique.ihm.composant.JTextFieldEA;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import util.FileUtils;
import util.GuiUtils;
import util.MsgUtils;

public class Repertoire
extends JFrame {
    private Bienvenue frBienvenue;
    private JTextFieldEA txtDirWork;
    private JButtonEA btContinue;
    private JCheckBoxEA cbCopieExemple;

    public Repertoire(int x, int y, Bienvenue f, final EvolutionPP evolution, final ParametrePP parametre) {
        this.setTitle("EPP-Lab");
        this.setResizable(false);
        this.setDefaultCloseOperation(3);
        this.setLocation(x, y);
        this.frBienvenue = f;
        Container conteneur = this.getContentPane();
        conteneur.setLayout(new BoxLayout(conteneur, 3));
        JEditorPane editeur = new JEditorPane();
        editeur.setEditable(false);
        editeur.setPreferredSize(new Dimension(400, 150));
        JScrollPane barre_verticale = new JScrollPane(editeur);
        barre_verticale.setVerticalScrollBarPolicy(20);
        barre_verticale.setMinimumSize(new Dimension(10, 10));
        URL message = this.getClass().getResource("/ihm/html/repertoire.html");
        try {
            editeur.setPage(message);
        }
        catch (IOException e) {
            editeur.setText("Le fichier 'repertoire.html' est introuvable.");
        }
        conteneur.add(barre_verticale);
        JPanel jpDirWork = new JPanel();
        jpDirWork.setLayout(new BorderLayout(4, 4));
        jpDirWork.setBorder(GuiUtils.BORDER_2);
        this.txtDirWork = new JTextFieldEA("Choisir un r\u00e9pertoire...");
        jpDirWork.add((Component)this.txtDirWork, "Center");
        JButtonEA btParcourirRep = new JButtonEA(EPPLab.msg.getString("bt.parcourir"));
        btParcourirRep.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser(System.getProperty("user.home"));
                fc.setFileSelectionMode(1);
                int returnVal = fc.showDialog(Repertoire.this, EPPLab.msg.getString("bt.ajouter"));
                if (returnVal == 0) {
                    File src = fc.getSelectedFile();
                    int choix = 0;
                    if (src.listFiles().length != 0) {
                        choix = JOptionPane.showConfirmDialog(Repertoire.this, "Le r\u00e9pertoire choisi n'est pas vide.\nEtes-vous s\u00fbr de vouloir continuer ?", "Avertissement", 0, 2);
                    }
                    if (choix == 0) {
                        Repertoire.this.txtDirWork.setText(src.getAbsolutePath());
                        Repertoire.this.btContinue.setEnabled(true);
                    }
                }
            }
        });
        jpDirWork.add((Component)btParcourirRep, "East");
        conteneur.add(jpDirWork);
        JPanel jp1 = new JPanel(GuiUtils.FL_LEFT_00);
        this.cbCopieExemple = new JCheckBoxEA("Fichiers exemples");
        jp1.add((Component)this.cbCopieExemple);
        conteneur.add(jp1);
        JPanel jpCde = new JPanel();
        jpCde.setLayout(new BorderLayout());
        jpCde.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        JButtonEA btRetour = new JButtonEA("Retour");
        btRetour.setEnabled(true);
        btRetour.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Repertoire.this.setVisible(false);
                Repertoire.this.frBienvenue.setVisible(true);
            }
        });
        jpCde.add((Component)btRetour, "West");
        this.btContinue = new JButtonEA(EPPLab.msg.getString("bt.continuer"));
        this.btContinue.setEnabled(false);
        this.btContinue.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Repertoire.this.setVisible(false);
                parametre.updatePath(Repertoire.this.txtDirWork.getText());
                if (Repertoire.this.cbCopieExemple.isSelected()) {
                    try {
                        FileUtils.copierFichier((InputStream)this.getClass().getResourceAsStream("/ihm/data/don1.txt"), (String)(parametre.rep_donnees + File.separatorChar + "don1.txt"));
                        FileUtils.copierFichier((InputStream)this.getClass().getResourceAsStream("/ihm/data/don3.txt"), (String)(parametre.rep_donnees + File.separatorChar + "don3.txt"));
                        FileUtils.copierFichier((InputStream)this.getClass().getResourceAsStream("/ihm/data/lubischew.txt"), (String)(parametre.rep_donnees + File.separatorChar + "lubischew.txt"));
                        FileUtils.copierFichier((InputStream)this.getClass().getResourceAsStream("/ihm/data/olive.txt"), (String)(parametre.rep_donnees + File.separatorChar + "olive.txt"));
                    }
                    catch (IOException ex) {
                        MsgUtils.erreur((Window)Repertoire.this, (String)("Probl\u00e8me lors de la copie des exemples dans le r\u00e9pertoire\n'" + parametre.rep_donnees + "'"), (String)"Copie des exemples");
                    }
                }
                new Ihm(Repertoire.this.getX(), Repertoire.this.getY(), evolution, parametre);
            }
        });
        jpCde.add((Component)this.btContinue, "East");
        conteneur.add(jpCde);
        this.pack();
        this.setVisible(true);
    }
}

