/*
 * Decompiled with CFR 0.152.
 */
package javalain.algorithmegenetique.gene;

import javalain.algorithmegenetique.Gene;
import javalain.algorithmegenetique.gene.Bit;

public final class Trit
extends Gene {
    private char valeur;

    public Trit() {
        switch ((int)(Math.random() * 3.0)) {
            case 0: {
                this.valeur = (char)48;
                break;
            }
            case 1: {
                this.valeur = (char)49;
                break;
            }
            default: {
                this.valeur = (char)42;
            }
        }
    }

    private Trit(char c) {
        this.valeur = c;
    }

    public void set(char c) {
        if (c != '0' && c != '1' && c != '*') {
            throw new IllegalArgumentException("Trit, set (char c) : caractere non valide ('0', '1' ou '*').");
        }
        this.valeur = c;
    }

    public char get() {
        return this.valeur;
    }

    public Gene melanger(Gene g) {
        if (this.valeur == ((Trit)g).valeur) {
            return new Trit(this.valeur);
        }
        return new Trit();
    }

    public void mutation() {
        switch ((int)(Math.random() * 3.0)) {
            case 0: {
                this.valeur = (char)48;
                break;
            }
            case 1: {
                this.valeur = (char)49;
                break;
            }
            default: {
                this.valeur = (char)42;
            }
        }
    }

    public Gene copier() {
        return new Trit(this.valeur);
    }

    public Gene creer() {
        return new Trit();
    }

    public Gene creer(Gene g) {
        if (g instanceof Bit) {
            if (Math.random() > 0.5) {
                return new Trit('*');
            }
            return new Trit(((Bit)g).get());
        }
        if (g instanceof Trit) {
            if (Math.random() > 0.5) {
                return new Trit('*');
            }
            return g.copier();
        }
        throw new IllegalArgumentException("Trit, creer (Gene g) : g doit etre une instance de Bit ou Trit.");
    }

    public boolean estEgalA(Gene g) {
        if (g instanceof Trit) {
            return this.valeur == ((Trit)g).valeur;
        }
        if (g instanceof Bit) {
            return this.valeur == ((Bit)g).get();
        }
        return false;
    }

    public boolean estPlusGeneralQue(Gene g) {
        if (g instanceof Bit) {
            return this.valeur == '*' || this.valeur == ((Bit)g).get();
        }
        if (g instanceof Trit) {
            return this.valeur == '*' || this.valeur == ((Trit)g).valeur;
        }
        return false;
    }

    public StringBuilder afficher() {
        return new StringBuilder().append(this.valeur);
    }
}

