/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.probdist.NormalDist;
import umontreal.iro.lecuyer.randvar.NormalGen;
import umontreal.iro.lecuyer.rng.RandomStream;

public class NormalPolarGen
extends NormalGen {
    private double mu;
    private double sigma;
    private boolean available = false;
    private double[] variates = new double[2];
    private static double[] staticVariates = new double[2];

    public NormalPolarGen(RandomStream randomStream, NormalDist normalDist) {
        super(randomStream, normalDist);
        this.mu = normalDist.getMu();
        this.sigma = normalDist.getSigma();
    }

    public double nextDouble() {
        if (this.available) {
            this.available = false;
            return this.mu + this.sigma * this.variates[1];
        }
        NormalPolarGen.polar(this.stream, this.mu, this.sigma, this.variates);
        this.available = true;
        return this.mu + this.sigma * this.variates[0];
    }

    public static double nextDouble(RandomStream randomStream, double d, double d2) {
        NormalPolarGen.polar(randomStream, d, d2, staticVariates);
        return d + d2 * staticVariates[0];
    }

    private static void polar(RandomStream randomStream, double d, double d2, double[] dArray) {
        double d3;
        double d4;
        double d5;
        while ((d5 = (d4 = 2.0 * randomStream.nextDouble() - 1.0) * d4 + (d3 = 2.0 * randomStream.nextDouble() - 1.0) * d3) > 1.0 || d5 == 0.0) {
        }
        double d6 = Math.sqrt(-2.0 * Math.log(d5) / d5);
        dArray[0] = d3 * d6;
        dArray[1] = d4 * d6;
    }
}

