/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.rng;

import umontreal.iro.lecuyer.rng.RandomStream;

public class TruncatedRandomStream
implements RandomStream {
    private RandomStream stream;
    private double a;
    private double bminusa;

    public TruncatedRandomStream(RandomStream randomStream, double d, double d2) {
        if (randomStream == null) {
            throw new NullPointerException("The given stream must not be null");
        }
        if (d >= d2) {
            throw new IllegalArgumentException("a must be smaller than b");
        }
        if (d < 0.0 || d2 < 0.0 || d > 1.0 || d2 > 1.0) {
            throw new IllegalArgumentException("a and b must be in [0, 1]");
        }
        this.stream = randomStream;
        this.a = d;
        this.bminusa = d2 - d;
    }

    public void resetStartStream() {
        this.stream.resetStartStream();
    }

    public void resetStartSubstream() {
        this.stream.resetStartSubstream();
    }

    public void resetNextSubstream() {
        this.stream.resetNextSubstream();
    }

    public double nextDouble() {
        double d = this.stream.nextDouble();
        return this.a + d * this.bminusa;
    }

    public void nextArrayOfDouble(double[] dArray, int n, int n2) {
        this.stream.nextArrayOfDouble(dArray, n, n2);
        for (int i = n; i < n + n2; ++i) {
            dArray[i] = this.a + dArray[i] * this.bminusa;
        }
    }

    public int nextInt(int n, int n2) {
        return n + (int)(this.nextDouble() * (double)(n2 - n + 1));
    }

    public void nextArrayOfInt(int n, int n2, int[] nArray, int n3, int n4) {
        for (int i = n3; i < n3 + n4; ++i) {
            nArray[i] = this.nextInt(n, n2);
        }
    }
}

