/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.hups;

import umontreal.iro.lecuyer.hups.PointSet;
import umontreal.iro.lecuyer.hups.PointSetIterator;
import umontreal.iro.lecuyer.rng.RandomStream;

public class Rank1Lattice
extends PointSet {
    protected double[] v;
    protected double normFactor;
    protected double[] shift;

    public Rank1Lattice(int n, int[] nArray, int n2) {
        this.dim = n2;
        this.numPoints = n;
        this.normFactor = 1.0 / (double)n;
        this.v = new double[n2];
        for (int i = 0; i < n2; ++i) {
            if (nArray[i] < 0 || nArray[i] >= n) {
                throw new IllegalArgumentException("Rank1Lattice must have 0 <= a[j] < n");
            }
            this.v[i] = this.normFactor * (double)nArray[i];
        }
    }

    public void addRandomShift(int n, int n2, RandomStream randomStream) {
        int n3;
        if (null == randomStream) {
            throw new IllegalArgumentException("\n   Calling addRandomShift with null stream");
        }
        if (0 == n2) {
            n2 = Math.max(1, this.dim);
        }
        if (this.shift == null) {
            this.shift = new double[n2];
            this.capacityShift = n2;
        } else if (n2 > this.capacityShift) {
            for (n3 = Math.max(4, this.capacityShift); n2 > n3; n3 *= 2) {
            }
            double[] dArray = new double[n3];
            this.capacityShift = n3;
            for (int i = 0; i < n; ++i) {
                dArray[i] = this.shift[i];
            }
            this.shift = dArray;
        }
        this.dimShift = n2;
        for (n3 = n; n3 < n2; ++n3) {
            this.shift[n3] = randomStream.nextDouble();
        }
        this.shiftStream = randomStream;
    }

    public void clearRandomShift() {
        super.clearRandomShift();
        this.shift = null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Rank1Lattice:\n");
        stringBuffer.append(super.toString());
        return stringBuffer.toString();
    }

    public double getCoordinate(int n, int n2) {
        return this.v[n2] * (double)n % 1.0;
    }

    protected long modPower(long l, int n, int n2) {
        if (n == 0) {
            return 1L;
        }
        if (n == 1) {
            return l % (long)n2;
        }
        if ((n & 1) == 1) {
            return l * this.modPower(l, n - 1, n2) % (long)n2;
        }
        long l2 = this.modPower(l, n / 2, n2);
        return l2 * l2 % (long)n2;
    }

    protected double radicalInverse(int n, int n2) {
        double d;
        double d2 = d = 1.0 / (double)n;
        double d3 = 0.0;
        while (n2 > 0) {
            d3 += d2 * (double)(n2 % n);
            d2 *= d;
            n2 /= n;
        }
        return d3;
    }

    public PointSetIterator iterator() {
        return new Rank1LatticeIterator();
    }

    protected class Rank1LatticeIterator
    extends PointSet.DefaultPointSetIterator {
        protected Rank1LatticeIterator() {
        }

        public double nextCoordinate() {
            if (this.curPointIndex >= Rank1Lattice.this.numPoints || this.curCoordIndex >= Rank1Lattice.this.dim) {
                this.outOfBounds();
            }
            double d = (double)this.curPointIndex * Rank1Lattice.this.v[this.curCoordIndex] % 1.0;
            if (Rank1Lattice.this.shift != null) {
                if (this.curCoordIndex >= Rank1Lattice.this.dimShift) {
                    Rank1Lattice.this.addRandomShift(Rank1Lattice.this.dimShift, this.curCoordIndex + 1, Rank1Lattice.this.shiftStream);
                }
                if ((d += Rank1Lattice.this.shift[this.curCoordIndex]) >= 1.0) {
                    d -= 1.0;
                }
            }
            ++this.curCoordIndex;
            return d;
        }
    }
}

