% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_s3_rendopstarlm.R
\name{confint.rendo.pstar.lm}
\alias{confint.rendo.pstar.lm}
\title{Confidence Interval for copula correction models fitted with augmented OLS.}
\usage{
\method{confint}{rendo.pstar.lm}(object, parm, level = 0.95,
  num.simulations = 250L, ...)
}
\arguments{
\item{object}{a fitted model object.}

\item{parm}{a specification of which parameters are to be given
    confidence intervals, either a vector of numbers or a vector of
    names.  If missing, all parameters are considered.}

\item{level}{the confidence level required.}

\item{num.simulations}{the number of times the model is re-fitted to obtain confidence intervals in case of discrete endogenous regressors only. Ignored with a warning otherwise.}

\item{...}{ignored, for consistency with the generic function.}
}
\description{
In the case of only discrete endogenous regressors, the model is re-fitted multiple times
and the confidence interval is obtained for each fitted model. The mean of all simulated confidence
intervals per parameter is reported.

In all other cases, the standard method for a fitted linear model \code{\link[stats]{lm}} is applied.
}
\seealso{
\code{\link[stats]{confint}} for the standard method for linear models

\code{\link{copulaCorrection}} for more information about the model's background
}
