% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toxCRM.R
\name{toxCRM}
\alias{toxCRM}
\title{Concentration-Response Model, 4-parameter log-logistic curve}
\usage{
toxCRM(x, max = 1, min = 0, steep, mid, eMean = 0, eSD = 0, seed = NULL)
}
\arguments{
\item{x}{numeric vector of chemical concentrations (univariate)}

\item{max}{numeric value, asymptotic maximum of model (default = \code{1})}

\item{min}{numeric value, asymptotic minimum of model (default = \code{0})}

\item{steep}{numeric value, steepness factor for model slope}

\item{mid}{numeric value, inflection point concentration for CRM slope}

\item{eMean}{numeric value, mean of random-normal error to add to dummy toxicity data (default = \code{0})}

\item{eSD}{numeric value, standard deviation of random-normal error to add to dummy toxicity data (default = \code{0})}

\item{seed}{numeric value, random seed to set for repeatable random error generating (default = \code{NULL}, i.e., no seed)}
}
\value{
numeric vector
}
\description{
Generate dummy toxicity data with strong concentration-response
}
\details{
\code{toxCRM} generates dummy toxicity data representing an
idealized condition. This approach was used by the authors to simulate data and test \code{FPM} sensitivity
and baseline variability. The user must specify all coefficients of the model (though
default min/max values are provided) and may add some amount of random error, if desired.
Random error adds noise to the dummy toxicity daata, increasing the uncertainty of toxicity predictions using floating percentile model benchmarks. The
\code{perfect}, \code{lowNoise}, and \code{highNoise} datasets included in \code{RFPM} were all generated
using \code{toxCRM} with increasing levels of \code{eSD}.
}
\examples{
concentration = h.northport$Cu
toxVals <- toxCRM(x = concentration,
    max = 1, min = 0, steep = 0.5, mid = median(concentration), eMean = 0, eSD = 0)
plot(x = concentration, y = toxVals, log = "x", main = "Perfect estimate")

toxVals_withNoise <- toxCRM(x = concentration,
    max = 1, min = 0, steep = 0.5, mid = median(concentration), eMean = 0, eSD = 0.1, seed = 1)
plot(x = concentration, y = toxVals_withNoise, log = "x", main = "Noisy estimate")
}
\seealso{
perfect, lowNoise, highNoise
}
