/*
 * Decompiled with CFR 0.152.
 */
package freak.module.view;

import freak.core.control.Schedule;
import freak.core.view.AbstractView;
import freak.core.view.swingsupport.FreakTextFieldModel;
import freak.core.view.swingsupport.UpdateManager;
import java.awt.Dimension;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class VoteView
extends AbstractView {
    private FreakTextFieldModel textYes = new FreakTextFieldModel();
    private FreakTextFieldModel textNo;
    private int numYes = 0;
    private int numNo = 0;

    public VoteView(Schedule schedule) {
        super(schedule);
        this.textYes.setText("Yes: 0");
        this.textNo = new FreakTextFieldModel();
        this.textNo.setText("No: 0");
    }

    public Class[] getInputDataTypes() {
        return new Class[]{Boolean.class};
    }

    public JPanel createPanel() {
        JPanel panel = new JPanel();
        JTextField textField = new JTextField();
        textField.setPreferredSize(new Dimension(200, 40));
        JTextField textField2 = new JTextField();
        textField2.setPreferredSize(new Dimension(200, 40));
        this.textYes.setView(textField);
        this.textNo.setView(textField2);
        panel.add(textField);
        panel.add(textField2);
        return panel;
    }

    public String getName() {
        return "Vote View";
    }

    public String getDescription() {
        return "Counts the number of positive and negative results.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Object data) {
        Boolean wrapper = (Boolean)data;
        if (wrapper.booleanValue()) {
            ++this.numYes;
        } else {
            ++this.numNo;
        }
        double percYes = (double)this.numYes / (double)(this.numYes + this.numNo) * 100.0;
        double percNo = (double)this.numNo / (double)(this.numYes + this.numNo) * 100.0;
        FreakTextFieldModel freakTextFieldModel = this.textYes;
        synchronized (freakTextFieldModel) {
            this.textYes.setText("Yes: " + this.numYes + "  " + percYes + "%");
        }
        freakTextFieldModel = this.textNo;
        synchronized (freakTextFieldModel) {
            this.textNo.setText("No: " + this.numNo + "  " + percNo + "%");
        }
        UpdateManager.markDirty(this.textYes);
        UpdateManager.markDirty(this.textNo);
    }
}

