/*
 * Decompiled with CFR 0.152.
 */
package freak.module.fitness.cycle;

import freak.core.control.Schedule;
import freak.core.event.BatchEvent;
import freak.core.event.BatchEventListener;
import freak.core.event.EventListener;
import freak.core.fitness.AbstractStaticSingleObjectiveFitnessFunction;
import freak.core.population.Genotype;
import freak.module.searchspace.Cycle;
import freak.module.searchspace.PermutationGenotype;

public class ATSP
extends AbstractStaticSingleObjectiveFitnessFunction
implements BatchEventListener {
    private double[][] costMatrix;

    public ATSP(Schedule schedule) {
        super(schedule);
    }

    public void initialize() {
        super.initialize();
        int dim = ((Cycle)this.getSchedule().getPhenotypeSearchSpace()).getDimension();
        if (this.costMatrix != null && this.costMatrix.length != dim) {
            this.costMatrix = new double[dim][dim];
            int i = 0;
            while (i < dim) {
                int j = 0;
                while (j < dim) {
                    this.costMatrix[i][j] = i != j ? this.getSchedule().getRandomElement().uniform(1.0, 2.0) : 0.0;
                    ++j;
                }
                ++i;
            }
        }
    }

    public double evaluate(Genotype genotype) {
        double cost = 0.0;
        int[] gene = ((PermutationGenotype)genotype).getIntArray();
        int pos = 1;
        while (pos < gene.length) {
            cost += this.costMatrix[gene[pos - 1] - 1][gene[pos] - 1];
            ++pos;
        }
        return 1.0 / (cost += this.costMatrix[gene[gene.length - 1] - 1][gene[0] - 1]);
    }

    public double getOptimalFitnessValue() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public double getLowerBound() throws UnsupportedOperationException {
        return 0.0;
    }

    public double getUpperBound() throws UnsupportedOperationException {
        return 1.0;
    }

    public Genotype getPhenotypeOptimum() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public String getDescription() {
        return "The traveling salesman problem is to find a tour through n locations with minimal costs.\nA cost matrix describes the costs of travelling from i to j for each pair of locations.";
    }

    public String getName() {
        return "Asymmetric TSP";
    }

    public void batchStarted(BatchEvent evt) {
        int dim = ((Cycle)this.getSchedule().getPhenotypeSearchSpace()).getDimension();
        this.costMatrix = new double[dim][dim];
        int i = 0;
        while (i < dim) {
            int j = 0;
            while (j < dim) {
                this.costMatrix[i][j] = i != j ? this.getSchedule().getRandomElement().uniform(1.0, 2.0) : 0.0;
                ++j;
            }
            ++i;
        }
    }

    public void createEvents() {
        this.schedule.getEventController().addEvent((EventListener)this, BatchEvent.class, this.schedule);
    }
}

