/*
 * Decompiled with CFR 0.152.
 */
package freak.gui;

import freak.core.control.BatchList;
import freak.core.control.EventController;
import freak.core.modulesupport.Module;
import freak.core.modulesupport.inspector.InspectorVetoException;
import freak.gui.ConfigurationPanel;
import freak.gui.JButtonFactory;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class PropertyDialog
extends JDialog {
    private Module module;
    private EventController eventController;
    private ConfigurationPanel configPanel;
    private JButton buClose;
    private JPanel configPanelContainer;

    public PropertyDialog(Dialog parent, EventController eventController, Module module, Object[] eventSources, BatchList batchList) {
        super(parent, true);
        this.initComponents();
        this.setSize(400, 450);
        this.setLocationRelativeTo(parent);
        this.initCommon(eventController, module, eventSources, batchList);
    }

    public PropertyDialog(JFrame parent, EventController eventController, Module module, Object[] eventSources, BatchList batchList) {
        super((Frame)parent, true);
        this.initComponents();
        this.setSize(350, 400);
        this.setLocationRelativeTo(parent);
        this.initCommon(eventController, module, eventSources, batchList);
    }

    private void initCommon(EventController eventController, Module module, Object[] eventSources, BatchList batchList) {
        this.module = module;
        this.eventController = eventController;
        this.configPanel = new ConfigurationPanel(module, eventController, eventSources, batchList);
        this.configPanelContainer.add(this.configPanel);
    }

    private void initComponents() {
        this.buClose = JButtonFactory.newButton();
        this.configPanelContainer = new JPanel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(0);
        this.setTitle("Configure Module...");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                PropertyDialog.this.closeDialog(evt);
            }
        });
        this.buClose.setMnemonic('c');
        this.buClose.setText("Close");
        this.buClose.setToolTipText("Closes the Configuration Dialog.");
        this.buClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PropertyDialog.this.buCloseActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.getContentPane().add((Component)this.buClose, gridBagConstraints);
        this.configPanelContainer.setLayout(new BoxLayout(this.configPanelContainer, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.configPanelContainer, gridBagConstraints);
        this.pack();
    }

    private void buCloseActionPerformed(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent evt) {
        try {
            this.configPanel.finishEditing();
        }
        catch (InspectorVetoException e) {
            JOptionPane.showMessageDialog(this, "This module's properties are invalid.\n" + e.getMessage(), "Invalid Property Settings", 0);
            return;
        }
        this.setVisible(false);
        this.dispose();
    }
}

