/*
 * Decompiled with CFR 0.152.
 */
package freak.module.mapper.bitstring;

import freak.core.control.Schedule;
import freak.core.event.BatchEvent;
import freak.core.event.BatchEventListener;
import freak.core.event.EventListener;
import freak.core.mapper.AbstractMapper;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.inspector.CustomizableInspector;
import freak.core.modulesupport.inspector.Inspector;
import freak.core.modulesupport.inspector.StandardInspectorFactory;
import freak.core.population.Genotype;
import freak.core.searchspace.SearchSpace;
import freak.module.searchspace.BitString;
import freak.module.searchspace.BitStringGenotype;
import freak.module.searchspace.BitStringGenotypeEditor;
import java.util.BitSet;
import javax.swing.JTable;

public class XOR_Mapper
extends AbstractMapper
implements BatchEventListener,
Configurable {
    private BitSet shift;
    private boolean randomly = false;

    public XOR_Mapper(Schedule schedule) {
        super(schedule);
        if (schedule.getPhenotypeSearchSpace() instanceof BitString) {
            int dim = ((BitString)schedule.getPhenotypeSearchSpace()).getDimension();
            this.shift = new BitSet(dim);
            this.shift.set(0, dim);
        }
    }

    public void initialize() {
        super.initialize();
        int dim = ((BitString)this.schedule.getPhenotypeSearchSpace()).getDimension();
        if (this.shift != null && this.shift.size() != dim) {
            this.shift = new BitSet(dim);
            this.shift.set(0, dim);
        }
    }

    public Genotype genotypeToPhenotype(Genotype genotype) {
        BitSet set = (BitSet)((BitStringGenotype)genotype).getBitSet().clone();
        set.xor(this.shift);
        return new BitStringGenotype(set, ((BitString)this.schedule.getPhenotypeSearchSpace()).getDimension());
    }

    public Genotype phenotypeToGenotype(Genotype genotype) {
        BitSet set = (BitSet)((BitStringGenotype)genotype).getBitSet().clone();
        set.xor(this.shift);
        return new BitStringGenotype(set, ((BitString)this.schedule.getPhenotypeSearchSpace()).getDimension());
    }

    public SearchSpace getGenotypeSearchSpace() {
        return this.schedule.getPhenotypeSearchSpace();
    }

    public String getName() {
        return "XOR Mapper";
    }

    public String getDescription() {
        return "Before the fitness of an individual is evaluated an xor operation on its genotype is performed.";
    }

    public Boolean getPropertyRandomly() {
        return new Boolean(this.randomly);
    }

    public void setPropertyRandomly(Boolean randomly) {
        this.randomly = randomly;
    }

    public BitStringGenotype getPropertyShift() {
        return new BitStringGenotype(this.shift, ((BitString)this.getGenotypeSearchSpace()).getDimension());
    }

    public void setPropertyShift(BitStringGenotype geno) {
        this.shift = geno.getBitSet();
    }

    public Inspector getInspector() {
        CustomizableInspector inspector = StandardInspectorFactory.getStandardInspectorFor(this);
        inspector.customize(BitStringGenotype.class, new JTable().getDefaultRenderer(String.class), new BitStringGenotypeEditor());
        return inspector;
    }

    public void createEvents() {
        this.schedule.getEventController().addEvent((EventListener)this, BatchEvent.class, this.schedule);
    }

    public void batchStarted(BatchEvent evt) {
        if (this.randomly) {
            BitString bs = new BitString(this.getSchedule(), ((BitString)this.schedule.getPhenotypeSearchSpace()).getDimension());
            this.shift = ((BitStringGenotype)bs.getRandomGenotype()).getBitSet();
        }
    }
}

