/*
 * Decompiled with CFR 0.152.
 */
package freak.module.fitness.bitstring;

import freak.core.control.Schedule;
import freak.core.fitness.AbstractStaticMultiObjectiveFitnessFunction;
import freak.core.population.Genotype;
import freak.core.population.Individual;
import freak.core.population.IndividualList;
import freak.module.searchspace.BitString;
import freak.module.searchspace.BitStringGenotype;
import java.util.BitSet;
import java.util.Iterator;

public class SineCosine
extends AbstractStaticMultiObjectiveFitnessFunction {
    public SineCosine(Schedule schedule) {
        super(schedule);
    }

    protected double[] evaluate(Genotype genotype) {
        BitSet bs = ((BitStringGenotype)genotype).getBitSet();
        int card = bs.cardinality();
        int n = ((BitString)this.getSchedule().getGenotypeSearchSpace()).getDimension();
        double x = (double)card / (double)n;
        x = x * 2.0 * Math.PI;
        double[] result = new double[]{Math.sin(x), Math.cos(x)};
        return result;
    }

    public int getDimensionOfObjectiveSpace() {
        return 2;
    }

    public String getName() {
        return "Sine and Cosine";
    }

    public String getDescription() {
        return "Let n be the dimension of the search space and i the number of ones in the genotype. Then the fitness is calculated as (sin(2*Pi*i/n),cos(2*Pi*i/n)).";
    }

    public boolean containsParetoFront(IndividualList list) {
        int dimension = ((BitString)this.getSchedule().getGenotypeSearchSpace()).getDimension();
        int paretoFrontEnds = dimension / 4;
        if (dimension % 4 == 3) {
            paretoFrontEnds = dimension / 4 + 1;
        }
        if (list.size() < paretoFrontEnds + 1) {
            return false;
        }
        boolean[] exists = new boolean[paretoFrontEnds + 1];
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Individual ind = (Individual)it.next();
            int card = ((BitStringGenotype)ind.getGenotype()).getBitSet().cardinality();
            if (card <= paretoFrontEnds) {
                exists[card] = true;
                continue;
            }
            if (card != dimension) continue;
            exists[0] = true;
        }
        int i = 0;
        while (i < paretoFrontEnds + 1) {
            if (!exists[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

