/*
 * Decompiled with CFR 0.152.
 */
package freak.module.operator.selection;

import edu.cornell.lassp.houle.RngPack.RandomElement;
import freak.core.control.Schedule;
import freak.core.fitness.FitnessFunction;
import freak.core.fitness.SingleObjectiveFitnessFunction;
import freak.core.graph.CompatibleWithDifferentSearchSpaces;
import freak.core.graph.OperatorGraph;
import freak.core.graph.Selection;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.population.Individual;
import freak.core.population.IndividualList;
import freak.core.population.Population;
import java.util.Iterator;

public class CutSelection
extends Selection
implements Configurable,
CompatibleWithDifferentSearchSpaces {
    private int noOfIndividualsToSelect = 1;
    private boolean fastCut = true;

    public CutSelection(OperatorGraph graph) {
        super(graph);
        super.addInPort();
        super.addOutPort();
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        super.testSchedule(schedule);
        if (!(this.graph.getSchedule().getFitnessFunction() instanceof SingleObjectiveFitnessFunction)) {
            throw new UnsupportedEnvironmentException("This operator works on single objective fitness functions only.");
        }
        try {
            ((SingleObjectiveFitnessFunction)schedule.getFitnessFunction()).compareIndividuals(null, null);
            this.fastCut = true;
        }
        catch (UnsupportedOperationException e) {
            this.fastCut = false;
        }
    }

    public IndividualList[] selectOneOnly(IndividualList[] input) {
        if (input[0].size() <= 1) {
            return input;
        }
        IndividualList[] output = new IndividualList[]{new Population(this.graph.getSchedule(), 1)};
        Iterator it = input[0].iterator();
        SingleObjectiveFitnessFunction fitness = (SingleObjectiveFitnessFunction)this.graph.getSchedule().getFitnessFunction();
        Individual theBest = (Individual)it.next();
        while (it.hasNext()) {
            Individual rival = (Individual)it.next();
            switch (fitness.compareIndividuals(theBest, rival)) {
                case 0: {
                    if (theBest.getDateOfBirth() >= rival.getDateOfBirth()) break;
                    theBest = rival;
                    break;
                }
                case -1: {
                    theBest = rival;
                }
            }
        }
        output[0].addIndividual(theBest);
        return output;
    }

    public IndividualList[] process(IndividualList[] original) {
        if (this.noOfIndividualsToSelect == 1 && this.fastCut) {
            return this.selectOneOnly(original);
        }
        if (original[0].size() == 0) {
            IndividualList[] result = new IndividualList[]{new Population(this.getOperatorGraph().getSchedule())};
            return result;
        }
        IndividualList[] result = new IndividualList[]{new Population(this.graph.getSchedule(), this.noOfIndividualsToSelect)};
        Individual[] origin = original[0].toArray();
        FitnessFunction fitness = this.graph.getSchedule().getFitnessFunction();
        int generation = this.graph.getSchedule().getCurrentGeneration();
        double[] fValue = new double[origin.length];
        boolean[] thisGen = new boolean[origin.length];
        int i = 0;
        while (i < origin.length) {
            fValue[i] = ((SingleObjectiveFitnessFunction)fitness).evaluate(origin[i], original[0]);
            thisGen[i] = origin[i].getDateOfBirth() == generation;
            ++i;
        }
        Individual[] selResult = this.quickSelect(origin, fValue, thisGen, this.noOfIndividualsToSelect, this.graph.getSchedule().getRandomElement());
        int i2 = 0;
        while (i2 < this.noOfIndividualsToSelect) {
            result[0].addIndividual(selResult[i2]);
            ++i2;
        }
        return result;
    }

    public Integer getPropertyNoOfIndividualsToSelect() {
        return new Integer(this.noOfIndividualsToSelect);
    }

    public void setPropertyNoOfIndividualsToSelect(Integer noOfIndividualsToSelect) {
        this.noOfIndividualsToSelect = noOfIndividualsToSelect;
        if (this.noOfIndividualsToSelect <= 0) {
            this.noOfIndividualsToSelect = 1;
        }
    }

    public String getShortDescriptionForNoOfIndividualsToSelect() {
        return "Selected individuals";
    }

    public String getLongDescriptionForNoOfIndividualsToSelect() {
        return "The number of individuals to be selected.";
    }

    /*
     * Unable to fully structure code
     */
    private Individual[] quickSelect(Individual[] origin, double[] fValue, boolean[] thisGen, int noToSelect, RandomElement randomGen) {
        pivot = randomGen.choose(0, origin.length - 1);
        left = 0;
        right = origin.length - 1;
        result = new Individual[noToSelect];
        if (noToSelect != origin.length) ** GOTO lbl34
        i = 0;
        while (i < noToSelect) {
            result[i] = origin[i];
            ++i;
        }
        return result;
        {
            ++left;
            do {
                if ((fValue[left] > fValue[pivot] || fValue[left] == fValue[pivot] && thisGen[left]) && left < pivot) continue block1;
                while ((fValue[right] <= fValue[pivot] || fValue[right] == fValue[pivot] && !thisGen[right]) && right > pivot) {
                    --right;
                }
                if (left != right) {
                    temp = fValue[left];
                    fValue[left] = fValue[right];
                    fValue[right] = temp;
                    temp2 = origin[left];
                    origin[left] = origin[right];
                    origin[right] = temp2;
                    if (pivot == left) {
                        pivot = right;
                    } else if (pivot == right) {
                        pivot = left;
                    }
                }
                if (left < pivot) {
                    ++left;
                }
                if (right <= pivot) continue;
                --right;
lbl34:
                // 3 sources

            } while (left != right);
        }
        if (pivot + 1 < noToSelect) {
            i = 0;
            while (i < pivot + 1) {
                result[i] = origin[i];
                ++i;
            }
            newOrigin = new Individual[origin.length - pivot - 1];
            newFValue = new double[origin.length - pivot - 1];
            newThisGen = new boolean[origin.length - pivot - 1];
            i = 0;
            while (i < origin.length - pivot - 1) {
                newOrigin[i] = origin[pivot + 1 + i];
                newFValue[i] = fValue[pivot + 1 + i];
                newThisGen[i] = thisGen[pivot + 1 + i];
                ++i;
            }
            selResult = this.quickSelect(newOrigin, newFValue, newThisGen, noToSelect - pivot - 1, randomGen);
            i = 0;
            while (i < selResult.length) {
                result[pivot + 1 + i] = selResult[i];
                ++i;
            }
            return result;
        }
        if (pivot + 1 == noToSelect) {
            i = 0;
            while (i < noToSelect) {
                result[i] = origin[i];
                ++i;
            }
            return result;
        }
        if (pivot + 1 > noToSelect) {
            newOrigin = new Individual[pivot];
            newFValue = new double[pivot];
            newThisGen = new boolean[pivot];
            i = 0;
            while (i < pivot) {
                newOrigin[i] = origin[i];
                newFValue[i] = fValue[i];
                newThisGen[i] = thisGen[i];
                ++i;
            }
            result = this.quickSelect(newOrigin, newFValue, newThisGen, noToSelect, randomGen);
            return result;
        }
        return result;
    }

    public String getName() {
        return "Cut Selection";
    }

    public String getDescription() {
        return "Selects the best individuals. Individuals coming from this generation are preferred if their fitness values equal.";
    }
}

