/*
 * Decompiled with CFR 0.152.
 */
package freak.module.view.plotter;

import freak.module.view.plotter.Plotter;
import freak.module.view.plotter.Point;
import freak.module.view.plotter.PointList;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JPanel;

public abstract class AbstractPlotterPanel
extends JPanel {
    final Plotter view;
    public static final int LEFT_MARGIN = 40;
    public static final int RIGHT_MARGIN = 15;
    public static final int TOP_MARGIN = 10;
    public static final int BOTTOM_MARGIN = 25;
    transient XAxis xAxis;
    transient YAxis yAxis;
    transient PlotArea plotArea;

    public AbstractPlotterPanel(Plotter view) {
        this.view = view;
    }

    public abstract void flush();

    public abstract int getStartingGenerations();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        Plotter plotter = this.view;
        synchronized (plotter) {
            super.paint(g);
            this.view.xValues.synchronizeViews();
        }
    }

    public static double roundToNiceValue(double value) {
        double numberOfDecimalDigits = Math.log(value) / Math.log(10.0);
        double result = Math.pow(10.0, Math.ceil(numberOfDecimalDigits));
        while (value * 1.4142135623730951 < result) {
            result /= 2.0;
        }
        return result;
    }

    public static String roundToString(double value) {
        String s = String.valueOf(value);
        if (s.indexOf(46) > -1 && s.length() - s.indexOf(46) - 1 > 7) {
            return String.valueOf((double)Math.round(value * 1000000.0) / 1000000.0);
        }
        return s;
    }

    Color getColorForPointIndex(int index, int number) {
        return new Color(Color.HSBtoRGB((float)index / (float)number, 1.0f, 0.75f));
    }

    abstract int computeDisplayXCoordinate(int var1);

    int computeDisplayYCoordinate(double y) {
        int baseLine = (int)this.plotArea.getBounds().getMaxY() - this.plotArea.getInsets().bottom - 5;
        return (int)((double)baseLine - (y - this.view.yAxisLowerBound) * (double)this.yAxis.height / (this.view.yAxisUpperBound - this.view.yAxisLowerBound));
    }

    boolean isXPositionVisible(int currentXValue) {
        return true;
    }

    class XAxis
    extends JComponent {
        transient int minVisibleX;
        transient int maxVisibleX;
        transient int xGenStepWidth;
        transient int xGenStart;
        transient Graphics graphics;

        XAxis() {
        }

        public void paintComponent(Graphics graphics) {
            this.graphics = graphics;
            this.divideXAxis();
            this.computeVisibleBounds();
            int ypos = 0;
            int minX = 0;
            int maxX = (int)this.getBounds().getWidth();
            graphics.setColor(Color.black);
            graphics.drawLine(minX - 5, ypos, maxX + 5, ypos);
            int x = this.xGenStart = this.minVisibleX - this.minVisibleX % this.xGenStepWidth;
            while (x <= this.maxVisibleX) {
                int xpos = AbstractPlotterPanel.this.computeDisplayXCoordinate(x);
                this.drawTickOnXAxis(String.valueOf(x), xpos, ypos);
                x += this.xGenStepWidth;
            }
        }

        void computeVisibleBounds() {
            this.minVisibleX = AbstractPlotterPanel.this.view.xAxisMin;
            this.maxVisibleX = AbstractPlotterPanel.this.view.xAxisMax;
        }

        void drawTickOnXAxis(String text, int xpos, int ypos) {
            int height = this.graphics.getFontMetrics().getHeight();
            int width = this.graphics.getFontMetrics().stringWidth(text);
            this.graphics.drawLine(xpos, ypos, xpos, ypos + 5);
            this.graphics.drawString(text, xpos - width / 2, ypos + height + 5);
        }

        void divideXAxis() {
            double xStepWidthRaw = 60 * (AbstractPlotterPanel.this.view.xAxisMax - AbstractPlotterPanel.this.view.xAxisMin) / AbstractPlotterPanel.this.plotArea.getWidth();
            this.xGenStepWidth = Math.max(1, (int)AbstractPlotterPanel.roundToNiceValue(xStepWidthRaw));
        }
    }

    class YAxis
    extends JComponent {
        transient double yGridStepWidth;
        transient double yGridStart;
        transient int newWidth;
        transient int height;
        transient Graphics graphics;

        YAxis() {
        }

        public void paintComponent(Graphics graphics) {
            this.divideYAxis();
            this.graphics = graphics;
            Rectangle bounds = this.getBounds();
            this.newWidth = this.getWidth();
            int xpos = (int)bounds.getMaxX() - 0;
            int minY = (int)AbstractPlotterPanel.this.plotArea.getBounds().getMinY() + AbstractPlotterPanel.this.plotArea.getInsets().top;
            int maxY = (int)AbstractPlotterPanel.this.plotArea.getBounds().getMaxY() - AbstractPlotterPanel.this.plotArea.getInsets().bottom;
            graphics.setColor(Color.black);
            graphics.drawLine(xpos, minY - 5, xpos, maxY + 5);
            if (AbstractPlotterPanel.this.view.yAxisLowerBound == AbstractPlotterPanel.this.view.yAxisUpperBound) {
                this.drawTickOnYAxis(AbstractPlotterPanel.roundToString(AbstractPlotterPanel.this.view.yAxisLowerBound), xpos, maxY);
                this.drawTickOnYAxis(AbstractPlotterPanel.roundToString(AbstractPlotterPanel.this.view.yAxisUpperBound), xpos, minY);
            } else {
                double y = this.yGridStart;
                while (y <= AbstractPlotterPanel.this.view.yAxisUpperBound) {
                    int ypos = AbstractPlotterPanel.this.computeDisplayYCoordinate(y) + 1;
                    this.drawTickOnYAxis(AbstractPlotterPanel.roundToString(y), xpos, ypos);
                    y += this.yGridStepWidth;
                }
            }
            if (this.newWidth > this.getWidth()) {
                this.setPreferredSize(new Dimension(this.newWidth, this.getPreferredSize().height));
                this.revalidate();
            }
        }

        void drawTickOnYAxis(String text, int xpos, int ypos) {
            int offset = this.graphics.getFontMetrics().getAscent() / 2;
            int width = this.graphics.getFontMetrics().stringWidth(text);
            this.graphics.drawLine(xpos - 5, ypos, xpos, ypos);
            this.graphics.drawString(text, xpos - width - 10, ypos + offset);
            if (width + 15 > this.newWidth) {
                this.newWidth = width + 15;
            }
        }

        void divideYAxis() {
            this.height = AbstractPlotterPanel.this.plotArea.getHeight() - AbstractPlotterPanel.this.plotArea.getInsets().top - AbstractPlotterPanel.this.plotArea.getInsets().bottom - 10 - 5;
            double yStepWidthRaw = 30.0 * (AbstractPlotterPanel.this.view.yAxisUpperBound - AbstractPlotterPanel.this.view.yAxisLowerBound) / (double)this.height;
            this.yGridStepWidth = AbstractPlotterPanel.roundToNiceValue(yStepWidthRaw);
            this.yGridStart = Math.ceil(AbstractPlotterPanel.this.view.yAxisLowerBound / this.yGridStepWidth) * this.yGridStepWidth;
        }
    }

    class PlotArea
    extends JComponent {
        public static final int TOP_INSETS = 10;
        public static final int BOTTOM_INSETS = 5;
        transient int minVisibleX;
        transient int maxVisibleX;
        transient int pointSize;
        private Rectangle bounds;
        transient Graphics graphics;
        private XAxis xAxis;
        private YAxis yAxis;

        public PlotArea(XAxis xAxis, YAxis yAxis) {
            this.xAxis = xAxis;
            this.yAxis = yAxis;
            this.pointSize = 2;
        }

        public void paintComponent(Graphics graphics) {
            this.graphics = graphics;
            this.bounds = this.getBounds();
            this.xAxis.divideXAxis();
            this.yAxis.divideYAxis();
            this.computeVisibleBounds();
            this.drawGrid();
            this.drawPoints();
        }

        void computeVisibleBounds() {
            this.minVisibleX = AbstractPlotterPanel.this.view.xAxisMin;
            this.maxVisibleX = AbstractPlotterPanel.this.view.xAxisMax;
        }

        void drawPoints() {
            int xStart;
            this.graphics.setColor(AbstractPlotterPanel.this.view.pointColor);
            this.pointSize = this.xAxis.xGenStepWidth < 50 ? 2 : 1;
            int pointXStepWidth = Math.max(1, this.xAxis.xGenStepWidth / 10);
            PointList oldList = null;
            int i = xStart = this.minVisibleX - this.minVisibleX % this.xAxis.xGenStepWidth;
            while (i <= this.maxVisibleX) {
                PointList list = null;
                try {
                    list = (PointList)AbstractPlotterPanel.this.view.xValues.get(i - this.minVisibleX);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                if (list != null) {
                    int j = 0;
                    while (j < list.data.length) {
                        this.drawPoint(list.data[j]);
                        if (AbstractPlotterPanel.this.view.showLines && oldList != null && j < oldList.data.length) {
                            this.graphics.setColor(AbstractPlotterPanel.this.getColorForPointIndex(j, list.data.length));
                            this.graphics.drawLine(oldList.data[j].xpos, oldList.data[j].ypos, list.data[j].xpos, list.data[j].ypos);
                            this.graphics.setColor(AbstractPlotterPanel.this.view.pointColor);
                        }
                        ++j;
                    }
                    oldList = list;
                }
                i += pointXStepWidth;
            }
        }

        void drawPoint(Point point) {
            point.xpos = AbstractPlotterPanel.this.computeDisplayXCoordinate((int)point.x);
            point.ypos = AbstractPlotterPanel.this.computeDisplayYCoordinate(point.y);
            this.graphics.drawLine(point.xpos - this.pointSize, point.ypos - this.pointSize, point.xpos + this.pointSize, point.ypos + this.pointSize);
            this.graphics.drawLine(point.xpos - this.pointSize, point.ypos + this.pointSize, point.xpos + this.pointSize, point.ypos - this.pointSize);
        }

        void drawGrid() {
            int xStart;
            this.graphics.setColor(Color.lightGray);
            double y = this.yAxis.yGridStart;
            while (y < AbstractPlotterPanel.this.view.yAxisUpperBound + this.yAxis.yGridStepWidth) {
                int ypos = AbstractPlotterPanel.this.computeDisplayYCoordinate(y);
                this.graphics.drawLine(0, ypos, this.getWidth(), ypos);
                y += this.yAxis.yGridStepWidth;
            }
            int x = xStart = (int)Math.ceil((double)this.minVisibleX / (double)this.xAxis.xGenStepWidth) * this.xAxis.xGenStepWidth;
            while (x <= this.maxVisibleX) {
                int xpos = AbstractPlotterPanel.this.computeDisplayXCoordinate(x);
                this.graphics.drawLine(xpos, 0, xpos, this.getHeight());
                x += this.xAxis.xGenStepWidth;
            }
        }

        boolean isXPositionVisible(int x) {
            this.xAxis.divideXAxis();
            int pointXStepWidth = Math.max(1, this.xAxis.xGenStepWidth / 10);
            int xStart = this.minVisibleX - this.minVisibleX % this.xAxis.xGenStepWidth;
            if (x < xStart || x > this.maxVisibleX) {
                return false;
            }
            return (x - xStart) % pointXStepWidth == 0;
        }
    }
}

