/*
 * Decompiled with CFR 0.152.
 */
package freak.core.modulesupport;

import freak.core.control.Schedule;
import freak.core.fitness.FitnessFunction;
import freak.core.fitness.FitnessTransformer;
import freak.core.graph.CompatibleWithDifferentSearchSpaces;
import freak.core.graph.Finish;
import freak.core.graph.Initialization;
import freak.core.graph.Operator;
import freak.core.graph.Start;
import freak.core.mapper.Mapper;
import freak.core.modulesupport.ClassCollector;
import freak.core.modulesupport.IncompatibleModuleException;
import freak.core.modulesupport.Module;
import freak.core.modulesupport.ModuleInfo;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.observer.Observer;
import freak.core.parametercontroller.ParameterController;
import freak.core.populationmanager.PopulationManager;
import freak.core.postprocessor.Postprocessor;
import freak.core.searchspace.SearchSpace;
import freak.core.stoppingcriterion.StoppingCriterion;
import freak.core.view.View;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedMap;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class ModuleCollector
extends ClassCollector {
    private Schedule schedule;

    public ModuleCollector(Schedule schedule) {
        this.schedule = schedule;
    }

    public Module newModule(Class c, Object[] param) throws UnsupportedEnvironmentException, InvocationTargetException {
        Constructor<?>[] constr = c.getConstructors();
        Module module = null;
        int i = 0;
        while (i < constr.length) {
            try {
                module = (Module)constr[i].newInstance(param);
                module.testSchedule(this.schedule);
                module.initialize();
                return module;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() != null && e.getTargetException() instanceof UnsupportedEnvironmentException) {
                    throw new UnsupportedEnvironmentException(c.toString());
                }
                throw e;
            }
            catch (InstantiationException e) {
                return null;
            }
            catch (UnsupportedEnvironmentException e) {
                throw e;
            }
            catch (Exception e) {
                System.err.println("The constructor of " + c.getName() + " doesn't work properly.\n" + e.toString());
                e.printStackTrace();
            }
            ++i;
        }
        System.err.println("->The class " + c.getName() + " doesn't have a constructor with the expected signature!");
        return null;
    }

    public Module newModuleByString(String mod, Object[] param, SearchSpace sesp) throws UnsupportedEnvironmentException, InvocationTargetException {
        Class<?> c = null;
        try {
            c = Class.forName(mod);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (c == null) {
            return null;
        }
        Module module = this.newModule(c, param);
        if (!(module instanceof CompatibleWithDifferentSearchSpaces)) {
            String s = sesp.getClass().getName().toLowerCase();
            int pos = mod.indexOf(s = s.substring(s.lastIndexOf(".") + 1));
            if (pos == -1) {
                throw new UnsupportedEnvironmentException(String.valueOf(module.getName()) + " is not compatible with the search space " + sesp.getName() + ".");
            }
        }
        return module;
    }

    private Module newModule(ModuleInfo mi, Object[] param) throws UnsupportedEnvironmentException, InvocationTargetException {
        Class<?> c = null;
        try {
            c = Class.forName(mi.getClassName());
        }
        catch (ClassNotFoundException e) {
            System.err.println("The class " + mi.getClassName() + " couldn't be found.!");
            e.printStackTrace();
        }
        if (c == null) {
            return null;
        }
        return this.newModule(c, param);
    }

    private Module[] instantiateModules(Collection c, Object[] param) {
        ArrayList<Module> modules = new ArrayList<Module>();
        for (Class cl : c) {
            try {
                Module module = this.newModule(cl, param);
                if (module == null) continue;
                modules.add(module);
            }
            catch (UnsupportedEnvironmentException module) {
            }
            catch (InvocationTargetException e) {
                System.err.println("The following error occured during the instantiation of " + cl + ": " + e.getCause());
                e.getCause().printStackTrace();
            }
        }
        Module[] m = modules.toArray(new Module[modules.size()]);
        Arrays.sort(m, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                return ((Module)arg0).getName().compareTo(((Module)arg1).getName());
            }
        });
        return m;
    }

    private String getClassName(Module mod) {
        String s = mod.getClass().getName();
        s = s.substring(s.lastIndexOf(".") + 1);
        return s.toLowerCase();
    }

    public DefaultTreeModel getTreeModelOfOperators(SearchSpace searchspace) {
        SortedMap groups = this.getGroupedOperatorClasses(searchspace);
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("operators");
        for (String operatorType : groups.keySet()) {
            DefaultMutableTreeNode operatorTypeNode = new DefaultMutableTreeNode(operatorType);
            root.add(operatorTypeNode);
            List operators = (List)groups.get(operatorType);
            List moduleInfos = this.createModuleInfosFromClasses(operators);
            Collections.sort(moduleInfos, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((ModuleInfo)o1).getName().compareTo(((ModuleInfo)o2).getName());
                }
            });
            Iterator it2 = moduleInfos.iterator();
            while (it2.hasNext()) {
                operatorTypeNode.add(new DefaultMutableTreeNode(it2.next()));
            }
        }
        return new DefaultTreeModel(root);
    }

    private List createModuleInfosFromClasses(List classes) {
        LinkedList<ModuleInfo> moduleInfos = new LinkedList<ModuleInfo>();
        for (Class moduleClass : classes) {
            try {
                Module module = this.newModule(moduleClass, new Object[]{this.schedule.getOperatorGraph()});
                ModuleInfo mi = new ModuleInfo(module.getName(), module.getDescription(), moduleClass.getName());
                moduleInfos.add(mi);
            }
            catch (UnsupportedEnvironmentException module) {
            }
            catch (InvocationTargetException e) {
                System.err.println("The class " + moduleClass + " couldn't be instantiated!");
                e.printStackTrace();
            }
        }
        return moduleInfos;
    }

    public Operator newOperator(ModuleInfo mi) {
        Operator operator = null;
        try {
            operator = (Operator)this.newModule(mi, new Object[]{this.schedule.getOperatorGraph()});
        }
        catch (UnsupportedEnvironmentException e1) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
        catch (RuntimeException e1) {
            e1.printStackTrace();
        }
        return operator;
    }

    public Module[] getSearchSpaces() {
        Collection classes = this.getClasses("searchspace", SearchSpace.class, true);
        return this.instantiateModules(classes, new Object[]{this.schedule});
    }

    public Module[] getFitnessFunctions(SearchSpace searchspace) {
        Collection classes = this.getClasses("fitness." + this.getClassName(searchspace), FitnessFunction.class, true);
        return this.instantiateModules(classes, new Object[]{this.schedule});
    }

    public Module[] getPostprocessors(SearchSpace searchspace) {
        Collection classes = this.getClasses("postprocessor." + this.getClassName(searchspace), Postprocessor.class, true);
        return this.instantiateModules(classes, new Object[]{this.schedule});
    }

    public Module[] getFitnessTransformers() {
        Collection classes = this.getClasses("fitness.transformer", FitnessTransformer.class, true);
        return this.instantiateModules(classes, new Object[]{this.schedule});
    }

    public Module[] getParameterControllers() {
        Collection classes = this.getClasses("parametercontroller", ParameterController.class, true);
        return this.instantiateModules(classes, new Object[]{this.schedule.getOperatorGraph()});
    }

    public Module[] getStoppingCriteria() {
        Collection classes = this.getClasses("stoppingcriterion", StoppingCriterion.class, true);
        return this.instantiateModules(classes, new Object[]{this.schedule});
    }

    public Module[] getPopulationManagers() {
        Collection classes = this.getClasses("populationmanager", PopulationManager.class, true);
        return this.instantiateModules(classes, new Object[]{this.schedule});
    }

    public Module[] getMapper(SearchSpace searchspace) {
        Collection classes = this.getClasses("mapper." + this.getClassName(searchspace), Mapper.class, true);
        return this.instantiateModules(classes, new Object[]{this.schedule});
    }

    public Module[] getInitializationOperators() {
        Collection classes = this.getClasses("operator.initialization", Initialization.class, true);
        Module[] mlist = this.instantiateModules(classes, new Object[]{this.schedule.getOperatorGraph()});
        int i = 0;
        while (i < mlist.length) {
            ((Initialization)mlist[i]).hideNameProperty();
            ++i;
        }
        return mlist;
    }

    public Module[] getObservers() {
        Collection classes = this.getClasses("observer", Observer.class, true);
        return this.instantiateModules(classes, new Object[]{this.schedule});
    }

    public Module[] getViews() {
        Collection classes = this.getClasses("view", View.class, true);
        return this.instantiateModules(classes, new Object[]{this.schedule});
    }

    public void checkPackageOfModule(Module module) throws IncompatibleModuleException {
        if (module instanceof FitnessTransformer) {
            Collection classes = this.getClasses("fitness.transformer", FitnessTransformer.class, true);
            if (!classes.contains(module.getClass())) {
                throw new IncompatibleModuleException(this.schedule.getPhenotypeSearchSpace());
            }
        } else if (module instanceof FitnessFunction) {
            Collection classes = this.getClasses("fitness." + this.getClassName(this.schedule.getPhenotypeSearchSpace()), FitnessFunction.class, true);
            if (!classes.contains(module.getClass())) {
                throw new IncompatibleModuleException(this.schedule.getPhenotypeSearchSpace());
            }
        } else if (module instanceof Mapper) {
            Collection classes = this.getClasses("mapper." + this.getClassName(this.schedule.getPhenotypeSearchSpace()), Mapper.class, true);
            if (!classes.contains(module.getClass())) {
                throw new IncompatibleModuleException(this.schedule.getPhenotypeSearchSpace());
            }
        } else if (module instanceof Operator && !(module instanceof Start) && !(module instanceof Finish)) {
            SortedMap groups = this.getGroupedOperatorClasses(this.schedule.getGenotypeSearchSpace());
            boolean found = false;
            Iterator iter1 = groups.keySet().iterator();
            while (iter1.hasNext()) {
                List operators = (List)groups.get(iter1.next());
                Iterator iter2 = operators.iterator();
                while (iter2.hasNext()) {
                    if (!((Class)iter2.next()).equals(module.getClass())) continue;
                    found = true;
                }
            }
            if (!found) {
                throw new IncompatibleModuleException(this.schedule.getGenotypeSearchSpace());
            }
        }
    }
}

