/*
 * Decompiled with CFR 0.152.
 */
package freak.core.populationmanager;

import freak.core.control.Schedule;
import freak.core.event.IndividualListEvent;
import freak.core.event.IndividualListEventListener;
import freak.core.graph.GraphException;
import freak.core.graph.Initialization;
import freak.core.graph.OutputLengthMismatchException;
import freak.core.modulesupport.AbstractModule;
import freak.core.population.IndividualList;
import freak.core.population.NoSuchIndividualException;
import freak.core.population.Population;
import freak.core.populationmanager.PopulationManager;
import java.util.HashSet;

public abstract class AbstractPopulationManager
extends AbstractModule
implements PopulationManager {
    private IndividualList population = null;
    private HashSet individualListEventListeners = new HashSet();

    public AbstractPopulationManager(Schedule schedule) {
        super(schedule);
    }

    public void initPopulation(Initialization initialization) throws GraphException {
        this.population = new Population(this.getSchedule());
        if (initialization == null) {
            throw new NullPointerException("Specified initialization operator is null.");
        }
        IndividualList[] resultOfInitialization = initialization.process(new IndividualList[0]);
        if (resultOfInitialization == null || resultOfInitialization.length == 0) {
            throw new OutputLengthMismatchException("Output of initialization operator is missing.");
        }
        if (resultOfInitialization[0].isEmpty()) {
            throw new NoSuchIndividualException("Initialization operator provides an empty population.");
        }
        this.population.addAllIndividuals(resultOfInitialization[0]);
        this.fireIndividualList(this.population);
    }

    public IndividualList getPopulation() {
        return this.population;
    }

    protected void setPopulation(IndividualList population) {
        this.population = population;
    }

    public void addIndividualListEventListener(IndividualListEventListener l) {
        this.individualListEventListeners.add(l);
    }

    public void removeIndividualListEventListener(IndividualListEventListener l) {
        this.individualListEventListeners.remove(l);
    }

    protected void fireIndividualList(IndividualList population) {
        if (this.individualListEventListeners.size() > 0) {
            IndividualListEvent event = new IndividualListEvent(this, population);
            for (IndividualListEventListener listener : this.individualListEventListeners) {
                listener.individualList(event);
            }
        }
    }
}

