% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checks.R
\name{.checkKuttner}
\alias{.checkKuttner}
\title{Checks the input variables for the procedure \code{KuttnerModel} for consistency and validity.}
\usage{
.checkKuttner(
  tsl,
  trend,
  cycle,
  cycleLag,
  errorARMA,
  start,
  end,
  anchor,
  anchor.h
)
}
\arguments{
\item{tsl}{A list of time series objects, see details.}

\item{trend}{A character string specifying the trend model. \code{trend = "RW1"} denotes
a first order random walk, \code{trend = "RW2"} a second order random walk (local linear
trend) and \code{trend = "DT"} a damped trend model. The default is \code{trend = "RW1"}.}

\item{cycle}{A character string specifying the cycle model. \code{cycle = "AR1"} denotes
an AR(1) process, \code{cycle = "AR2"} an AR(2) process. The default is
\code{cycle = "AR2"}.}

\item{cycleLag}{A non-negative integer specifying the maximum cycle lag that is included
in the inflation equation. The default is \code{cycleLag = 0}, see details.}

\item{errorARMA}{A vector with non-negative integers specifying the AR
and MA degree of the error term in the inflation equation.}

\item{start}{(Optional) Start vector for the estimation, e.g. \code{c(1980, 1)}.}

\item{end}{(Optional) End vector for the estimation, e.g. \code{c(2020, 1)}.}

\item{anchor}{(Optional) Anchor value for the logarithm of trend gdp.}

\item{anchor.h}{(Optional) Anchor horizon in the frequency of the given time series.}
}
\description{
Checks the input variables for the procedure \code{KuttnerModel} for consistency and validity.
}
\keyword{internal}
