% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HRT.R
\docType{class}
\name{HRT}
\alias{HRT}
\alias{initialize,HRT-method}
\title{S4 class to represent an HRT object}
\usage{
\S4method{initialize}{HRT}(
  .Object,
  couplRR = NA_real_,
  compRR = NA_real_,
  preRRs = NA_real_,
  postRRs = NA_real_
)
}
\arguments{
\item{.Object}{(Character) The name of the class}

\item{couplRR}{(Numeric) Coupling interval}

\item{compRR}{(Numeric) Compensatory interval}

\item{preRRs}{(Numeric vector) Preceding intervals}

\item{postRRs}{(Numeric vector) Following intervals}
}
\value{
(HRT) A new HRT object
}
\description{
This class specifies an object to save the lengths of intervals surrounding a
premature ventricular beat. It saves the HRT parameters turbulence onset (TO),
slope (TS) and timing (TT) after calculation as well as the coefficients of an
ab-line used for the plot.
TS is saved after common calculation and after normalising.
}
\section{Slots}{

\describe{
\item{\code{couplRR}}{(Numeric) Coupling interval}

\item{\code{compRR}}{(Numeric) Compensatory interval}

\item{\code{preRRs}}{(Numeric vector) Preceding intervals}

\item{\code{postRRs}}{(Numeric vector) Following intervals}

\item{\code{TO}}{(Numeric) Turbulence onset}

\item{\code{TS}}{(Numeric) Turbulence slope}

\item{\code{TT}}{(Numeric) Turbulence timing}

\item{\code{intercept}}{(Numeric) Intercept of regression line of TS}

\item{\code{nTS}}{(Numeric) Normalised Turbulence slope}

\item{\code{nintercept}}{(Numeric) Intercept of regression line of nTS}
}}

