% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checknetMHCpan.R
\name{checknetMHCpan}
\alias{checknetMHCpan}
\title{checknetMHCpan}
\usage{
checknetMHCpan(
  netmhcpan_directory,
  netmhcpan_alleles,
  peptide_rerun,
  HF_step1_output,
  export_files = FALSE,
  export_dir = NULL
)
}
\arguments{
\item{netmhcpan_directory}{the directory in which the netMHCpan file is.}

\item{netmhcpan_alleles}{vector of comma-separated alleles for which these peptides
should be analyzed (i.e HLA_alleles_Exp1<- c("HLA-A*02:01", "HLA-A*03:01",
"HLA-A24:02"))}

\item{peptide_rerun}{dataframe containing the results of the second run}

\item{HF_step1_output}{the HybridFinder output containing the potential
splicing categorizations obtained with the HybridFinder function (HybridFinder)
based on the matching of fragment pairs of peptides in 1 or 2 proteins. This
parameter can be provided either by loading the .csv exported file, or if the
results #' object still is in the global environment (i.e results_HF_Exp1),
then it can be accessed by simply writing "results_HF_Exp1[[1]]".}

\item{export_files}{a boolean parameter for exporting the dataframes into
files in the next parameter for the output directory, Default: FALSE}

\item{export_dir}{export_dir the output directory for the results files
if export_files=TRUE, Default: NULL}
}
\value{
\enumerate{
   \item netMHCpan results pertaining to the binding affinity of all peptides
in the database search results (in long- and wide- format, with data tidying
in the wide format in order to compute the amount of HLA molecules to which
a peptide is strong/weak/non-binder binder)(dataframe)
    \item netMHCpan results pertaining to the binding affinity of the hybrid
peptides to the MHC molecules (in long- and wide- format, with data tidying
in the wide format in order to compute the amount of HLA molecules to which
a peptide is strong/weak/non-binder binder) (dataframe)
    \item the database search rerun with the categorizations already determined
    in step1 (HybridFinder Function)} (datafrane)
}
\description{
checknetMHCpan, utilizes the file from the second (PEAKS) run
and analyzes the data with netMHCpan in order to provide the peptide binding
affinity to different HLA/MHC alleles.
}
\details{
The ability to check the peptide binding affinity to the different
MHC/HLA molecules is essential for assessing the antigenicity of all peptides.
This function thus uses netMHCpan (Reynisson et al., 2020) for the generation
of binding affinty results.
}
\examples{
\dontrun{
  results_checknetmhcpan_Exp1<- checknetMHCpan('/usr/local/bin', alleles,
  peptide_rerun, Exp1_HF_results[[1]])
  results_checknetmhcpan_Exp1 <- checknetMHCpan('/usr/local/bin', alleles,
  peptide_rerun, Exp1_HF_results_denovo_w_spliced)
}
}
