% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{add_meta_to_filename}
\alias{add_meta_to_filename}
\title{Adds meta information (date and exchange) to an itch filename}
\usage{
add_meta_to_filename(file, date, exchange)
}
\arguments{
\item{file}{the filename}

\item{date}{the date as a date-class or as a string that is understood by
\code{\link[base:as.Date]{base::as.Date()}}.}

\item{exchange}{the name of the exchange}
}
\value{
the filename with exchanged or added date and exchange information
}
\description{
Note that if date and exchange information are already present,
they are overwritten
}
\examples{
add_meta_to_filename("03302017.NASDAQ_ITCH50", "2010-12-24", "TEST")
add_meta_to_filename("20170130.BX_ITCH_50.gz", "2010-12-24", "TEST")
add_meta_to_filename("S030220-v50-bx.txt.gz", "2010-12-24", "TEST")
add_meta_to_filename("unknown_file.ITCH_50", "2010-12-24", "TEST")
}
