% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{computeDirect}
\alias{computeDirect}
\title{Function to simulate the direct method}
\usage{
computeDirect(
  N = 120,
  analyte,
  params,
  seed = 123,
  NIter = 10000,
  RIperc = c(0.025, 0.975)
)
}
\arguments{
\item{N}{(integer) specifying the number of samples used as sample size for the direct method, default: 120}

\item{analyte}{(character) specifying the biomarker that is currently simulated}

\item{params}{(list) of parameters for non-pathological distribution (nonp_mu, nonp_sigma, nonp_lambda, and nonp_shift)}

\item{seed}{(integer) specifying the seed used for the simulation, default: 123}

\item{NIter}{(integer) specifiyng the number of times N samples should be drawn out of the simulated non-pathological distribution (default: 10,000)}

\item{RIperc}{(numeric) value specifying the percentiles, which define the reference interval}
}
\value{
(data frame) with the estimated reference intervals for NIter iterations
}
\description{
Function to simulate the direct method
}
\author{
Tatjana Ammer \email{tatjana.ammer@roche.com}
}
