/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;

public class Wand {
    static final int UP = 0;
    static final int DOWN = 1;
    static final int UP_OR_DOWN = 2;
    static final int LEFT = 3;
    static final int RIGHT = 4;
    static final int LEFT_OR_RIGHT = 5;
    static final int NA = 6;
    public int npoints;
    private int maxPoints = 1000;
    public int[] xpoints = new int[this.maxPoints];
    public int[] ypoints = new int[this.maxPoints];
    private ImageProcessor ip;
    private byte[] bpixels;
    private int[] cpixels;
    private short[] spixels;
    private float[] fpixels;
    private int width;
    private int height;
    private float lowerThreshold;
    private float upperThreshold;

    public Wand(ImageProcessor ip) {
        if (ip instanceof ByteProcessor) {
            this.bpixels = (byte[])ip.getPixels();
        } else if (ip instanceof ColorProcessor) {
            this.cpixels = (int[])ip.getPixels();
        } else if (ip instanceof ShortProcessor) {
            this.spixels = (short[])ip.getPixels();
        } else if (ip instanceof FloatProcessor) {
            this.fpixels = (float[])ip.getPixels();
        }
        this.width = ip.getWidth();
        this.height = ip.getHeight();
    }

    private float getColorPixel(int x, int y) {
        if (x >= 0 && x < this.width && y >= 0 && y < this.height) {
            return this.cpixels[y * this.width + x];
        }
        return Float.MAX_VALUE;
    }

    private float getBytePixel(int x, int y) {
        if (x >= 0 && x < this.width && y >= 0 && y < this.height) {
            return this.bpixels[y * this.width + x] & 0xFF;
        }
        return Float.MAX_VALUE;
    }

    private float getShortPixel(int x, int y) {
        if (x >= 0 && x < this.width && y >= 0 && y < this.height) {
            return this.spixels[y * this.width + x] & 0xFFFF;
        }
        return Float.MAX_VALUE;
    }

    private float getFloatPixel(int x, int y) {
        if (x >= 0 && x < this.width && y >= 0 && y < this.height) {
            return this.fpixels[y * this.width + x];
        }
        return Float.MAX_VALUE;
    }

    private float getPixel(int x, int y) {
        if (this.bpixels != null) {
            return this.getBytePixel(x, y);
        }
        if (this.spixels != null) {
            return this.getShortPixel(x, y);
        }
        if (this.fpixels != null) {
            return this.getFloatPixel(x, y);
        }
        return this.getColorPixel(x, y);
    }

    private boolean inside(int x, int y) {
        float value = this.bpixels != null ? this.getBytePixel(x, y) : (this.spixels != null ? this.getShortPixel(x, y) : (this.fpixels != null ? this.getFloatPixel(x, y) : this.getColorPixel(x, y)));
        return value >= this.lowerThreshold && value <= this.upperThreshold;
    }

    boolean isLine(int xs, int ys) {
        int ymax;
        int ymin;
        int r = 5;
        int xmin = xs;
        int xmax = xs + 2 * r;
        if (xmax >= this.width) {
            xmax = this.width - 1;
        }
        if ((ymin = ys - r) < 0) {
            ymin = 0;
        }
        if ((ymax = ys + r) >= this.height) {
            ymax = this.height - 1;
        }
        int area = 0;
        int insideCount = 0;
        for (int x = xmin; x <= xmax; ++x) {
            for (int y = ymin; y <= ymax; ++y) {
                ++area;
                if (!this.inside(x, y)) continue;
                ++insideCount;
            }
        }
        if (IJ.debugMode) {
            IJ.log(((double)insideCount / (double)area >= 0.75 ? "line " : "blob ") + insideCount + " " + area + " " + IJ.d2s((double)insideCount / (double)area));
        }
        return (double)insideCount / (double)area >= 0.75;
    }

    public void autoOutline(int startX, int startY) {
        int direction;
        int x = startX;
        int y = startY;
        this.lowerThreshold = this.upperThreshold = this.getPixel(startX, startY);
        while (this.inside(++x, y)) {
        }
        if (this.isLine(x, y)) {
            this.lowerThreshold = this.upperThreshold = this.getPixel(x, y);
            direction = 0;
        } else {
            direction = !this.inside(x - 1, y - 1) ? 4 : (this.inside(x, y - 1) ? 3 : 1);
        }
        this.traceEdge(x, y, direction);
    }

    public void autoOutline(int startX, int startY, double lower, double upper) {
        int direction;
        this.npoints = 0;
        int x = startX;
        int y = startY;
        this.lowerThreshold = (float)lower;
        this.upperThreshold = (float)upper;
        if (this.inside(x, y)) {
            while (this.inside(++x, y)) {
            }
            direction = !this.inside(x - 1, y - 1) ? 4 : (this.inside(x, y - 1) ? 3 : 1);
        } else {
            while (!this.inside(++x, y) && x < this.width) {
            }
            direction = 0;
            if (x >= this.width) {
                return;
            }
        }
        this.traceEdge(x, y, direction);
    }

    public void autoOutline(int startX, int startY, int lower, int upper) {
        this.autoOutline(startX, startY, (double)lower, (double)upper);
    }

    void traceEdge(int xstart, int ystart, int startingDirection) {
        int[] table = new int[]{6, 4, 1, 4, 0, 0, 2, 0, 3, 5, 1, 4, 3, 3, 1, 6};
        int x = xstart;
        int y = ystart;
        int direction = startingDirection;
        boolean UL = this.inside(x - 1, y - 1);
        boolean UR = this.inside(x, y - 1);
        boolean LL = this.inside(x - 1, y);
        boolean LR = this.inside(x, y);
        int count = 0;
        do {
            int newDirection;
            int index = 0;
            if (LR) {
                index |= 1;
            }
            if (LL) {
                index |= 2;
            }
            if (UR) {
                index |= 4;
            }
            if (UL) {
                index |= 8;
            }
            if ((newDirection = table[index]) == 2) {
                newDirection = direction == 4 ? 0 : 1;
            }
            if (newDirection == 5) {
                newDirection = direction == 0 ? 3 : 4;
            }
            if (newDirection != direction) {
                this.xpoints[count] = x;
                this.ypoints[count] = y;
                if (++count == this.xpoints.length) {
                    int[] xtemp = new int[this.maxPoints * 2];
                    int[] ytemp = new int[this.maxPoints * 2];
                    System.arraycopy(this.xpoints, 0, xtemp, 0, this.maxPoints);
                    System.arraycopy(this.ypoints, 0, ytemp, 0, this.maxPoints);
                    this.xpoints = xtemp;
                    this.ypoints = ytemp;
                    this.maxPoints *= 2;
                }
            }
            switch (newDirection) {
                case 0: {
                    LL = UL;
                    LR = UR;
                    UL = this.inside(x - 1, --y - 1);
                    UR = this.inside(x, y - 1);
                    break;
                }
                case 1: {
                    UL = LL;
                    UR = LR;
                    LL = this.inside(x - 1, ++y);
                    LR = this.inside(x, y);
                    break;
                }
                case 3: {
                    UR = UL;
                    LR = LL;
                    UL = this.inside(--x - 1, y - 1);
                    LL = this.inside(x - 1, y);
                    break;
                }
                case 4: {
                    UL = UR;
                    LL = LR;
                    UR = this.inside(++x, y - 1);
                    LR = this.inside(x, y);
                }
            }
            direction = newDirection;
        } while (x != xstart || y != ystart || direction != startingDirection);
        this.npoints = count;
    }
}

