/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.gui.Line;
import ij.gui.ShapeRoi;
import ij.process.ImageProcessor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;

public class Arrow
extends Line {
    public static final String STYLE_KEY = "arrow.style";
    public static final String WIDTH_KEY = "arrow.width";
    public static final String SIZE_KEY = "arrow.size";
    public static final String DOUBLE_HEADED_KEY = "arrow.double";
    public static final int FILLED = 0;
    public static final int NOTCHED = 1;
    public static final int OPEN = 2;
    public static final int HEADLESS = 3;
    public static final String[] styles = new String[]{"Filled", "Notched", "Open", "Headless"};
    private static int defaultStyle = (int)Prefs.get("arrow.style", 0.0);
    private static float defaultWidth = (float)Prefs.get("arrow.width", 2.0);
    private static double defaultHeadSize = (int)Prefs.get("arrow.size", 10.0);
    private static boolean defaultDoubleHeaded = Prefs.get("arrow.double", false);
    private int style;
    private double headSize = 10.0;
    private boolean doubleHeaded;

    public Arrow(double d, double d2, double d3, double d4) {
        super(d, d2, d3, d4);
        this.setStrokeWidth(2.0f);
        this.style = defaultStyle;
        this.headSize = defaultHeadSize;
        this.doubleHeaded = defaultDoubleHeaded;
    }

    public Arrow(int n, int n2, ImagePlus imagePlus) {
        super(n, n2, imagePlus);
        this.setStrokeWidth(defaultWidth);
        this.style = defaultStyle;
        this.headSize = defaultHeadSize;
        this.doubleHeaded = defaultDoubleHeaded;
    }

    public void draw(Graphics graphics) {
        if (this.ic == null) {
            return;
        }
        Color color = this.strokeColor != null ? this.strokeColor : ROIColor;
        graphics.setColor(color);
        this.x1d = (double)this.x + this.x1R;
        this.y1d = (double)this.y + this.y1R;
        this.x2d = (double)this.x + this.x2R;
        this.y2d = (double)this.y + this.y2R;
        this.x1 = (int)this.x1d;
        this.y1 = (int)this.y1d;
        this.x2 = (int)this.x2d;
        this.y2 = (int)this.y2d;
        int n = this.ic.screenXD(this.x1d);
        int n2 = this.ic.screenYD(this.y1d);
        int n3 = this.ic.screenXD(this.x2d);
        int n4 = this.ic.screenYD(this.y2d);
        int n5 = n + (n3 - n) / 2;
        int n6 = n2 + (n4 - n2) / 2;
        this.drawArrow((Graphics2D)graphics, null, n, n2, n3, n4);
        if (this.doubleHeaded) {
            this.drawArrow((Graphics2D)graphics, null, n3, n4, n, n2);
        }
        if (this.state != 0 && !this.overlay) {
            int n7 = 2;
            this.handleColor = Color.white;
            this.drawHandle(graphics, n - n7, n2 - n7);
            this.drawHandle(graphics, n3 - n7, n4 - n7);
            this.drawHandle(graphics, n5 - n7, n6 - n7);
        }
        if (this.state != 3) {
            IJ.showStatus(this.imp.getLocationAsString(this.x2, this.y2) + ", angle=" + IJ.d2s(this.getAngle(this.x1, this.y1, this.x2, this.y2)) + ", length=" + IJ.d2s(this.getLength()));
        }
        if (this.updateFullWindow) {
            this.updateFullWindow = false;
            this.imp.draw();
        }
    }

    void drawArrow(Graphics2D graphics2D, ImageProcessor imageProcessor, double d, double d2, double d3, double d4) {
        double d5 = imageProcessor == null ? this.ic.getMagnification() : 1.0;
        double d6 = this.getStrokeWidth();
        if (imageProcessor == null) {
            graphics2D.setStroke(new BasicStroke((float)(d6 * d5)));
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        double d7 = 8.0 + 10.0 * d6 * d5 * 0.5;
        double d8 = d3 - d;
        double d9 = d4 - d2;
        double d10 = Math.sqrt(d8 * d8 + d9 * d9);
        double d11 = d3 - (d8 /= d10) * (d7 *= this.headSize / 10.0);
        double d12 = d4 - (d9 /= d10) * d7;
        double d13 = this.style == 2 ? 0.45 : 0.35;
        double d14 = d13 * d7;
        double d15 = Math.round(d11 + d9 * d14);
        double d16 = Math.round(d12 - d8 * d14);
        double d17 = Math.round(d11 - d9 * d14);
        double d18 = Math.round(d12 + d8 * d14);
        double d19 = d3 - d8 * 0.85 * d7;
        double d20 = d4 - d9 * 0.85 * d7;
        if (d10 > d7 || this.style == 3) {
            double d21;
            double d22 = d21 = this.style == 2 ? 0.25 : 0.75;
            if (this.style == 2) {
                d7 /= 3.0;
            }
            double d23 = d21 * d9 * d7;
            if (this.style == 3) {
                d21 = 0.0;
            }
            int n = this.doubleHeaded || this.style == 3 ? (int)(d + d21 * d8 * d7) : (int)d;
            int n2 = this.doubleHeaded || this.style == 3 ? (int)(d2 + d21 * d9 * d7) : (int)d2;
            int n3 = (int)(d3 - d21 * d8 * d7);
            int n4 = (int)(d4 - d21 * d9 * d7);
            if (imageProcessor != null) {
                imageProcessor.drawLine(n, n2, n3, n4);
            } else {
                graphics2D.drawLine(n, n2, n3, n4);
            }
        }
        if (this.style == 3) {
            return;
        }
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)d15, (float)d16);
        generalPath.lineTo((float)d3, (float)d4);
        generalPath.lineTo((float)d17, (float)d18);
        if (this.style != 2) {
            if (this.style == 1) {
                generalPath.lineTo((float)d19, (float)d20);
            }
            generalPath.lineTo((float)d15, (float)d16);
        }
        if (imageProcessor != null) {
            if (this.style == 2) {
                imageProcessor.moveTo((int)d15, (int)d16);
                imageProcessor.lineTo((int)d3, (int)d4);
                imageProcessor.lineTo((int)d17, (int)d18);
            } else {
                imageProcessor.fill(new ShapeRoi(generalPath));
            }
        } else if (this.style == 2) {
            if (d != d3 || d2 != d4) {
                graphics2D.draw(generalPath);
            }
        } else {
            graphics2D.fill(generalPath);
        }
    }

    public void drawPixels(ImageProcessor imageProcessor) {
        int n = Math.round(this.getStrokeWidth());
        imageProcessor.setLineWidth(n);
        this.drawArrow(null, imageProcessor, this.x1, this.y1, this.x2, this.y2);
        if (this.doubleHeaded) {
            this.drawArrow(null, imageProcessor, this.x2, this.y2, this.x1, this.y1);
        }
    }

    protected int clipRectMargin() {
        double d = this.ic != null ? this.ic.getMagnification() : 1.0;
        double d2 = this.getStrokeWidth();
        double d3 = 8.0 + 10.0 * d2 * d * 0.5;
        return (int)Math.max(d3 * 2.0, this.headSize);
    }

    public boolean isDrawingTool() {
        return true;
    }

    public static void setDefaultWidth(double d) {
        defaultWidth = (float)d;
    }

    public static double getDefaultWidth() {
        return defaultWidth;
    }

    public void setStyle(int n) {
        this.style = n;
    }

    public int getStyle() {
        return this.style;
    }

    public static void setDefaultStyle(int n) {
        defaultStyle = n;
    }

    public static int getDefaultStyle() {
        return defaultStyle;
    }

    public void setHeadSize(double d) {
        this.headSize = d;
    }

    public double getHeadSize() {
        return this.headSize;
    }

    public static void setDefaultHeadSize(double d) {
        defaultHeadSize = d;
    }

    public static double getDefaultHeadSize() {
        return defaultHeadSize;
    }

    public void setDoubleHeaded(boolean bl) {
        this.doubleHeaded = bl;
    }

    public boolean getDoubleHeaded() {
        return this.doubleHeaded;
    }

    public static void setDefaultDoubleHeaded(boolean bl) {
        defaultDoubleHeaded = bl;
    }

    public static boolean getDefaultDoubleHeaded() {
        return defaultDoubleHeaded;
    }

    static {
        if (defaultStyle < 0 || defaultStyle > 3) {
            defaultStyle = 0;
        }
    }
}

