/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.IJ;
import ij.Macro;
import ij.Prefs;
import ij.io.OpenDialog;
import ij.plugin.frame.Recorder;
import ij.util.Java2;
import java.awt.EventQueue;
import java.io.File;
import javax.swing.JFileChooser;

public class DirectoryChooser {
    private String directory;
    private static String defaultDir;
    private String title;

    public DirectoryChooser(String string) {
        this.title = string;
        if (IJ.isMacOSX()) {
            this.getDirectoryUsingFileDialog(string);
        } else {
            String string2 = Macro.getOptions();
            if (string2 != null) {
                this.directory = Macro.getValue(string2, string, null);
            }
            if (this.directory == null) {
                if (EventQueue.isDispatchThread()) {
                    this.getDirectoryUsingJFileChooserOnThisThread(string);
                } else {
                    this.getDirectoryUsingJFileChooser(string);
                }
            }
        }
    }

    void getDirectoryUsingJFileChooser(final String string) {
        Java2.setSystemLookAndFeel();
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    JFileChooser jFileChooser = new JFileChooser();
                    if (defaultDir != null) {
                        jFileChooser.setCurrentDirectory(new File(defaultDir));
                    }
                    jFileChooser.setDialogTitle(string);
                    jFileChooser.setFileSelectionMode(1);
                    jFileChooser.setApproveButtonText("Select");
                    if (jFileChooser.showOpenDialog(null) == 0) {
                        String string2;
                        File file = jFileChooser.getCurrentDirectory();
                        File file2 = jFileChooser.getSelectedFile();
                        DirectoryChooser.this.directory = file.getPath();
                        if (!DirectoryChooser.this.directory.endsWith(File.separator)) {
                            DirectoryChooser.this.directory = DirectoryChooser.this.directory + File.separator;
                        }
                        if (DirectoryChooser.this.directory != null) {
                            defaultDir = DirectoryChooser.this.directory;
                        }
                        if ((string2 = file2.getName()).indexOf(":\\") != -1) {
                            DirectoryChooser.this.directory = (defaultDir = string2);
                        } else {
                            DirectoryChooser.this.directory = DirectoryChooser.this.directory + (string2 + File.separator);
                        }
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void getDirectoryUsingJFileChooserOnThisThread(String string) {
        Java2.setSystemLookAndFeel();
        try {
            JFileChooser jFileChooser = new JFileChooser();
            if (defaultDir != null) {
                jFileChooser.setCurrentDirectory(new File(defaultDir));
            }
            jFileChooser.setDialogTitle(string);
            jFileChooser.setFileSelectionMode(1);
            jFileChooser.setApproveButtonText("Select");
            if (jFileChooser.showOpenDialog(null) == 0) {
                String string2;
                File file = jFileChooser.getCurrentDirectory();
                File file2 = jFileChooser.getSelectedFile();
                this.directory = file.getPath();
                if (!this.directory.endsWith(File.separator)) {
                    this.directory = this.directory + File.separator;
                }
                if (this.directory != null) {
                    defaultDir = this.directory;
                }
                this.directory = (string2 = file2.getName()).indexOf(":\\") != -1 ? (defaultDir = string2) : this.directory + string2 + File.separator;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void getDirectoryUsingFileDialog(String string) {
        boolean bl = Prefs.useJFileChooser;
        Prefs.useJFileChooser = false;
        System.setProperty("apple.awt.fileDialogForDirectories", "true");
        OpenDialog openDialog = new OpenDialog(string, defaultDir, null);
        this.directory = openDialog.getDirectory() == null ? null : openDialog.getDirectory() + openDialog.getFileName() + "/";
        if (this.directory != null) {
            defaultDir = new File(this.directory).getParent();
        }
        System.setProperty("apple.awt.fileDialogForDirectories", "false");
        Prefs.useJFileChooser = bl;
    }

    public String getDirectory() {
        if (Recorder.record && !IJ.isMacOSX()) {
            Recorder.recordPath(this.title, this.directory);
        }
        return this.directory;
    }

    public static void setDefaultDirectory(String string) {
        if (string == null || new File(string).isDirectory()) {
            defaultDir = string;
        }
    }
}

